/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.encoding;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.misc.Base64;

public class EncryptUtil {
    private static final String MD5 = "MD5";
    private static final String SHA256 = "SHA-256";

    public static String encrypt(String sourceStr, String algorithm) {
        if (MD5.equals(algorithm)) {
            MessageDigest md = EncryptUtil.getMd5Instance();
            return EncryptUtil.innerDigest(sourceStr, md);
        }
        if (SHA256.equals(algorithm)) {
            MessageDigest md = EncryptUtil.getSha256Instance();
            return EncryptUtil.innerDigest(sourceStr, md);
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString("\u6682\u4e0d\u652f\u6301\u52a0\u5bc6\u7b97\u6cd5\uff1a%s", "EncryptUtil_1", "isc-iscb-util", new Object[0]), algorithm));
    }

    private static String innerDigest(String sourceStr, MessageDigest md) {
        md.update(sourceStr.getBytes(D.UTF_8));
        md.update((byte)0);
        byte[] btDigest = md.digest();
        return new String(Base64.encode(btDigest), D.UTF_8);
    }

    private static MessageDigest getMd5Instance() {
        try {
            return MessageDigest.getInstance(MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw CommonError.NO_SUCH_HASH_ALGO.create(e, MD5);
        }
    }

    private static MessageDigest getSha256Instance() {
        try {
            return MessageDigest.getInstance(SHA256);
        }
        catch (NoSuchAlgorithmException e) {
            throw CommonError.NO_SUCH_HASH_ALGO.create(e, SHA256);
        }
    }
}

