/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.encoding;

import kd.ai.gai.flow.script.encoding.Encoding;

public class Hex
extends Encoding {
    private static byte[] hexChar;
    private static int[] bits;

    public static boolean isHexString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] encode(byte[] data) {
        byte[] buffer = new byte[data.length << 1];
        int j = 0;
        for (int i = 0; i < data.length; ++i) {
            buffer[j++] = hexChar[data[i] >> 4 & 0xF];
            buffer[j++] = hexChar[data[i] & 0xF];
        }
        return buffer;
    }

    @Override
    public byte[] decode(byte[] data) {
        if ((data.length & 1) != 0) {
            throw new IllegalArgumentException("Invalid hex string!");
        }
        byte[] buffer = new byte[data.length >> 1];
        int j = 0;
        for (int i = 0; i < buffer.length; ++i) {
            int k = bits[data[j++]] << 4;
            if ((k += bits[data[j++]]) > 255) {
                throw new IllegalArgumentException("Invalid hex string!");
            }
            buffer[i] = (byte)k;
        }
        return buffer;
    }

    static {
        int i;
        hexChar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        bits = new int[256];
        for (i = 0; i < 256; ++i) {
            Hex.bits[i] = 255;
        }
        for (i = 0; i <= 9; ++i) {
            Hex.bits[48 + i] = i;
        }
        int j = 10;
        for (i = 0; i <= 5; ++i) {
            Hex.bits[97 + i] = j;
            Hex.bits[65 + i] = j++;
        }
    }
}

