/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.control.advanced;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.script.LifeScriptContext;
import kd.ai.gai.flow.script.LifeScriptEngine;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.core.Constructor;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.parser.Program;

public class Eval
implements Constructor {
    @Override
    public String name() {
        return "eval";
    }

    @Override
    public Object analyze(final Statement statement, Constructor.Position pos) throws ScriptException {
        final Object script = pos.getOperand(statement, 0);
        final LifeScriptEngine engine = statement.getEngine();
        final Map<String, Object> context = statement.getContext();
        return new Evaluator(){

            public String toString() {
                return "eval(" + script + ")";
            }

            @Override
            public Object eval(ScriptContext ctx) {
                Object o = Util.eval(ctx, script);
                if (o instanceof Evaluator) {
                    return ((Evaluator)o).eval(ctx);
                }
                if (o == null) {
                    return null;
                }
                CompiledScript compiled = this.compile(engine, context, o.toString());
                LifeScriptContext newCtx = new LifeScriptContext(ctx.getBindings(0));
                return this.evalScript(compiled, newCtx, statement.line());
            }

            private Object evalScript(CompiledScript compiled, LifeScriptContext newCtx, int line) {
                try {
                    return compiled.eval(newCtx);
                }
                catch (Throwable e) {
                    Util.rewrite(this, e, line);
                    throw CommonError.SCRIPT_RUNTIME_ERROR.wrap(e);
                }
            }

            private CompiledScript compile(LifeScriptEngine engine2, Map<String, Object> context2, String s) {
                try {
                    HashMap<String, Object> dupContext = new HashMap<String, Object>(context2.size());
                    dupContext.putAll(context2);
                    StringReader script2 = new StringReader(s);
                    Program compiled = engine2.compile(script2, dupContext);
                    return compiled;
                }
                catch (ScriptException e) {
                    throw CommonError.SCRIPT_GRAMMAR_ERROR.create(e, e.getMessage(), s);
                }
            }
        };
    }
}

