/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.control.decision;

import java.util.Map;
import javax.script.ScriptException;
import kd.ai.gai.flow.script.LifeScriptEngine;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.core.Constructor;
import kd.ai.gai.flow.script.core.LiteralBuilder;
import kd.ai.gai.flow.script.core.NotExpression;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.core.StatementBuilder;
import kd.ai.gai.flow.script.core.StatementEnd;
import kd.ai.gai.flow.script.core.StatementStart;
import kd.ai.gai.flow.script.core.StopAnalyzeElements;
import kd.ai.gai.flow.script.feature.control.decision.Decision;
import kd.ai.gai.flow.script.statement.Block;

public class If
implements Constructor,
StatementStart,
StatementEnd,
NotExpression,
StopAnalyzeElements {
    public static final Constructor KEYWORD = new If();

    public static Object create(LifeScriptEngine engine, Map<String, Object> ctx, int line, int column, Object condition, Object trueBody, Object falseBody) {
        return new Decision(condition, trueBody, line).set(falseBody);
    }

    private If() {
    }

    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "if";
    }

    @Override
    public StatementBuilder getStatementBuilder() {
        return null;
    }

    @Override
    public LiteralBuilder getLiteralBuilder() {
        return null;
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        Object condition = this.getCondition(statement, pos);
        if (pos.getOperand(statement, 1) instanceof Block) {
            Block trueBody = (Block)pos.getOperand(statement, 1);
            if (statement.length() == 3) {
                return new Decision(condition, trueBody.analyze(), statement.line());
            }
            Decision first = new Decision(condition, trueBody.analyze(), statement.line());
            Object next = Util.getTail(statement, pos, 2);
            return new Block(statement.getEngine(), statement.getContext(), statement.line(), new Object[]{first, next});
        }
        Object trueBody = Util.getTail(statement, pos, 1);
        return new Decision(condition, trueBody, statement.line());
    }

    private Object getCondition(Statement statement, Constructor.Position pos) throws ScriptException {
        Object condition = pos.getOperand(statement, 0);
        if (condition instanceof Statement) {
            condition = ((Statement)condition).analyze();
        }
        condition = Util.unwrap(condition);
        return condition;
    }
}

