/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.control.err;

import javax.script.ScriptException;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.script.core.Analyzer;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.feature.control.err.CatchEvaluator;
import kd.ai.gai.flow.script.feature.control.err.CatchPart;
import kd.ai.gai.flow.script.feature.control.err.FinallyPart;
import kd.ai.gai.flow.script.feature.control.err.TryCatchFinallyEvaluator;
import kd.ai.gai.flow.script.feature.control.err.TryPart;

public class TryCatchFinallyAnalyzer
implements Analyzer {
    @Override
    public Object analyze(Statement statement) throws ScriptException {
        int tryIndex = this.findTryPart(statement);
        if (tryIndex < 0) {
            return statement;
        }
        int catchIndex = this.findCatchPart(statement, tryIndex);
        int finallyIndex = this.findFinallyPart(statement, tryIndex);
        this.checkIndex(tryIndex, catchIndex, finallyIndex);
        Object tryPart = ((TryPart)statement.get(tryIndex)).analyze();
        CatchEvaluator catchPart = catchIndex < 0 ? null : ((CatchPart)statement.get(catchIndex)).analyze();
        Object finallyPart = finallyIndex < 0 ? null : ((FinallyPart)statement.get(finallyIndex)).analyze();
        TryCatchFinallyEvaluator e = new TryCatchFinallyEvaluator(tryPart, catchPart, finallyPart);
        if (tryIndex == 0 && finallyIndex == statement.length() - 1) {
            return e;
        }
        Object[] buffer = this.copyElements(statement, tryIndex, catchIndex, finallyIndex, e);
        return this.analyze(statement.reconstruct(buffer));
    }

    private void checkIndex(int tryIndex, int catchIndex, int finallyIndex) throws ScriptException {
        if (catchIndex < 0) {
            if (finallyIndex < 0) {
                throw new ScriptException(ResManager.loadKDString("try\u6ca1\u6709\u5bf9\u5e94\u7684catch\u6216finally\uff01", "TryCatchFinallyAnalyzer_0", "isc-iscb-util", new Object[0]));
            }
            if (finallyIndex != tryIndex + 1) {
                throw new ScriptException(ResManager.loadKDString("finally\u4e0d\u5728try\u4e4b\u540e\uff01", "TryCatchFinallyAnalyzer_1", "isc-iscb-util", new Object[0]));
            }
        } else {
            if (catchIndex != tryIndex + 1) {
                throw new ScriptException(ResManager.loadKDString("catch\u4e0d\u5728try\u4e4b\u540e\uff01", "TryCatchFinallyAnalyzer_2", "isc-iscb-util", new Object[0]));
            }
            if (finallyIndex >= 0 && finallyIndex != catchIndex + 1) {
                throw new ScriptException(ResManager.loadKDString("finally\u4e0d\u5728catch\u4e4b\u540e\uff01", "TryCatchFinallyAnalyzer_3", "isc-iscb-util", new Object[0]));
            }
        }
    }

    private Object[] copyElements(Statement statement, int tryIndex, int catchIndex, int finallyIndex, TryCatchFinallyEvaluator e) {
        int i;
        int start = tryIndex;
        int last = Math.max(finallyIndex, catchIndex);
        Object[] buffer = new Object[statement.length() - last + start];
        for (i = 0; i < start; ++i) {
            buffer[i] = statement.get(i);
        }
        buffer[start] = e;
        i = last + 1;
        int j = start + 1;
        while (i < statement.length()) {
            buffer[j] = statement.get(i);
            ++i;
            ++j;
        }
        return buffer;
    }

    private int findTryPart(Statement statement) {
        for (int i = 0; i < statement.length(); ++i) {
            if (!(statement.get(i) instanceof TryPart)) continue;
            return i;
        }
        return -1;
    }

    private int findCatchPart(Statement statement, int tryIndex) {
        for (int i = tryIndex + 1; i < statement.length(); ++i) {
            Object e = statement.get(i);
            if (e instanceof CatchPart) {
                return i;
            }
            if (!(e instanceof TryPart)) continue;
            return -1;
        }
        return -1;
    }

    private int findFinallyPart(Statement statement, int tryIndex) {
        for (int i = tryIndex + 1; i < statement.length(); ++i) {
            Object e = statement.get(i);
            if (e instanceof FinallyPart) {
                return i;
            }
            if (!(e instanceof TryPart)) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public int priority() {
        return -3;
    }
}

