/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.control.err;

import java.util.Set;
import javax.script.ScriptContext;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.except.OutOfMemoryException;
import kd.ai.gai.flow.except.UneatableException;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.feature.control.advanced.DebugTrap;
import kd.ai.gai.flow.script.feature.control.advanced.Debuggable;
import kd.ai.gai.flow.script.feature.control.err.CatchEvaluator;

public class TryCatchFinallyEvaluator
implements Evaluator,
Debuggable {
    private DebugTrap _tryPart;
    private DebugTrap _catchPart;
    private DebugTrap _finallyPart;

    public TryCatchFinallyEvaluator(Object tryPart, CatchEvaluator catchPart, Object finallyPart) {
        this._tryPart = new DebugTrap(tryPart, -1);
        this._catchPart = new DebugTrap(catchPart, -1);
        this._finallyPart = new DebugTrap(finallyPart, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(ScriptContext ctx) {
        try {
            Object object = Util.eval(ctx, this._tryPart.get(ctx));
            return object;
        }
        catch (Exception e) {
            Object o = this.evalCatch(ctx, e);
            if (e instanceof UneatableException) {
                throw (UneatableException)e;
            }
            if (e instanceof OutOfMemoryException) {
                throw (OutOfMemoryException)e;
            }
            Object object = o;
            return object;
        }
        finally {
            this.evalFinally(ctx);
        }
    }

    private void evalFinally(ScriptContext ctx) {
        Object finallyPart = this._finallyPart.get(ctx);
        if (finallyPart != null) {
            Util.eval(ctx, finallyPart);
        }
    }

    private Object evalCatch(ScriptContext ctx, Exception e) {
        CatchEvaluator catchPart = (CatchEvaluator)this._catchPart.get(ctx);
        if (catchPart == null) {
            throw D.e(e);
        }
        return catchPart.eval(ctx, e);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("try{\r\n").append(this._tryPart.directGetElement()).append("\r\n}");
        if (this._catchPart.directGetElement() != null) {
            sb.append("catch{\r\n").append(this._catchPart).append("\r\n}");
        }
        if (this._finallyPart.directGetElement() != null) {
            sb.append("finally{\r\n").append(this._finallyPart).append("\r\n}");
        }
        return sb.toString();
    }

    @Override
    public boolean attachBreakpoint(int line) {
        return this._tryPart.attachBreakpoint(line) || this._catchPart.attachBreakpoint(line) || this._finallyPart.attachBreakpoint(line);
    }

    @Override
    public void detachBreakpoint(int line) {
        this._tryPart.detachBreakpoint(line);
        this._catchPart.detachBreakpoint(line);
        this._finallyPart.detachBreakpoint(line);
    }

    @Override
    public void collectBreakpoints(Set<Integer> breakpoints) {
        this._tryPart.collectBreakpoints(breakpoints);
        this._catchPart.collectBreakpoints(breakpoints);
        this._finallyPart.collectBreakpoints(breakpoints);
    }

    @Override
    public int line() {
        return -1;
    }
}

