/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.control.loop;

import javax.script.ScriptException;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.analyzer.expr.MapConstructor;
import kd.ai.gai.flow.script.core.Constructor;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.core.LiteralBuilder;
import kd.ai.gai.flow.script.core.NotExpression;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.core.StatementBuilder;
import kd.ai.gai.flow.script.core.StatementEnd;
import kd.ai.gai.flow.script.core.StatementStart;
import kd.ai.gai.flow.script.feature.control.loop.ForEach;
import kd.ai.gai.flow.script.feature.control.loop.it.ForImpl;
import kd.ai.gai.flow.script.statement.Block;

public class For
implements Constructor,
StatementStart,
StatementEnd,
NotExpression {
    @Override
    public StatementBuilder getStatementBuilder() {
        return null;
    }

    @Override
    public LiteralBuilder getLiteralBuilder() {
        return null;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "for";
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        Object tmp = Util.getElement(statement, pos, 0);
        if (tmp instanceof MapConstructor) {
            return ForEach.parse(statement, pos);
        }
        return this.parse(statement, pos, tmp);
    }

    private Object parse(Statement statement, Constructor.Position pos, Object tmp) throws ScriptException {
        Statement smt = (Statement)tmp;
        Object init = this.getInit(smt);
        Object condition = this.getCondition(smt);
        Object step = this.getStep(smt);
        Object body = null;
        Object next = null;
        if (statement.length() > 2) {
            tmp = pos.getOperand(statement, 1);
            body = For.createBody(statement, pos, tmp);
            next = For.handleNextStatement(statement, pos, tmp);
        }
        Evaluator eva = this.createEvaluator(init, condition, step, body, statement.line());
        return For.handleReturns(statement, next, eva);
    }

    private Object getStep(Statement smt) throws ScriptException {
        if (smt.length() == 2) {
            return null;
        }
        return smt.get(2);
    }

    private Object getCondition(Statement smt) throws ScriptException {
        Object condition = smt.get(1);
        if (condition instanceof Statement && ((Statement)condition).length() == 0) {
            return Boolean.TRUE;
        }
        return condition;
    }

    private Object getInit(Statement smt) throws ScriptException {
        Object init = smt.get(0);
        if (init instanceof Statement && ((Statement)init).length() == 0) {
            return null;
        }
        return init;
    }

    public static Object handleReturns(Statement statement, Object next, Evaluator eva) {
        if (next == null) {
            return eva;
        }
        return new Block(statement.getEngine(), statement.getContext(), statement.line(), new Object[]{eva, next});
    }

    public static Object handleNextStatement(Statement statement, Constructor.Position pos, Object tmp) throws ScriptException {
        if (statement.length() > 3 && tmp instanceof Block) {
            return Util.getTail(statement, pos, 2);
        }
        return null;
    }

    public static Object createBody(Statement statement, Constructor.Position pos, Object tmp) throws ScriptException {
        Object body = tmp instanceof Block ? tmp : Util.getTail(statement, pos, 1);
        return body;
    }

    private Evaluator createEvaluator(Object init, Object condition, Object step, Object body, int line) {
        return new ForImpl(condition, init, body, step, line);
    }
}

