/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.control.loop;

import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.core.Constructor;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.core.Operator;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.data.ValueRange;
import kd.ai.gai.flow.script.feature.control.loop.RangeIterator;

public class RangeConstructor
implements Constructor,
Operator {
    @Override
    public String name() {
        return "..";
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public int priority() {
        return 20;
    }

    public String toString() {
        return "..";
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        Object start = Util.getElement(statement, pos, 0);
        Object end = Util.getElement(statement, pos, 1);
        return new RangeBuilder(start, end);
    }

    public static class RangeBuilder
    implements Evaluator {
        private Object start;
        private Object end;

        public RangeBuilder(Object start, Object end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public Object eval(ScriptContext ctx) {
            Object startValue = Util.eval(ctx, this.start);
            Object endValue = Util.eval(ctx, this.end);
            if (startValue instanceof Number && endValue instanceof Number) {
                int start = ((Number)startValue).intValue();
                int end = ((Number)endValue).intValue();
                return new RangeIterator(start, end, startValue, endValue);
            }
            if (startValue instanceof Comparable && endValue instanceof Comparable) {
                return new ValueRange<Comparable>((Comparable)startValue, (Comparable)endValue);
            }
            throw new UnsupportedOperationException("[" + startValue + " .. " + endValue + "]");
        }

        public String toString() {
            return this.start + " .. " + this.end;
        }
    }
}

