/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.control.loop;

import java.util.Iterator;
import kd.ai.gai.flow.script.data.Range;

public class RangeIterator
implements Iterator<Integer>,
Range {
    private int start;
    private int end;
    private int step;
    private Object startValue;
    private Object endValue;

    public RangeIterator(int start, int end, Object startValue, Object endValue) {
        this.start = start;
        this.end = end;
        this.step = start < end ? 1 : -1;
        this.startValue = startValue;
        this.endValue = endValue;
    }

    @Override
    public boolean hasNext() {
        if (this.step > 0) {
            return this.start <= this.end;
        }
        return this.start >= this.end;
    }

    @Override
    public Integer next() {
        int i = this.start;
        this.start += this.step;
        return i;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.startValue + " .. " + this.endValue;
    }

    @Override
    public Object getLBound() {
        return this.startValue;
    }

    @Override
    public Object getUBound() {
        return this.endValue;
    }
}

