/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.control.loop;

import java.util.Set;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.misc.Json2;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.core.Constructor;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.core.Identifier;
import kd.ai.gai.flow.script.core.NotExpression;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.core.StopAnalyzeElements;
import kd.ai.gai.flow.script.feature.control.advanced.DebugTrap;
import kd.ai.gai.flow.script.feature.control.advanced.Debuggable;
import kd.ai.gai.flow.script.misc.Const;

public class Throw
implements Constructor,
Identifier,
NotExpression,
StopAnalyzeElements {
    public static final Const<Boolean> DISABLE_CODED_MESSAGE = new Const<Boolean>(Boolean.FALSE);

    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "throw";
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        Object result = Util.getTail(statement, pos, 0);
        return this.createEvaluator(result, statement.line());
    }

    private Object createEvaluator(Object result, int line) {
        return new ThrowEvaluator(result, line);
    }

    public static String toMessage(Object value) {
        String message = value instanceof CharSequence ? value.toString() : Json2.toString(value);
        return message;
    }

    private static final class ThrowEvaluator
    implements Evaluator,
    Debuggable {
        private final DebugTrap trap;

        private ThrowEvaluator(Object result, int line) {
            this.trap = new DebugTrap(result, line);
        }

        @Override
        public Object eval(ScriptContext ctx) {
            Object result = this.trap.get(ctx);
            Object value = Util.eval(ctx, result);
            if (value instanceof Exception) {
                throw CommonError.SCRIPT_RUNTIME_ERROR.wrap((Throwable)value);
            }
            if (value == null || value instanceof CharSequence) {
                String message = D.s(value);
                if (message == null) {
                    throw new NullPointerException("{Message is empty.}");
                }
                throw new IscBizException(message);
            }
            throw new IscBizException(Throw.toMessage(value));
        }

        public String toString() {
            return "throw " + this.trap;
        }

        @Override
        public boolean attachBreakpoint(int line) {
            return this.trap.attachBreakpoint(line);
        }

        @Override
        public void detachBreakpoint(int line) {
            this.trap.detachBreakpoint(line);
        }

        @Override
        public void collectBreakpoints(Set<Integer> breakpoints) {
            this.trap.collectBreakpoints(breakpoints);
        }

        @Override
        public int line() {
            return this.trap.line();
        }
    }
}

