/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.control.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.ai.gai.flow.misc.mem.MemoryUtil;
import kd.ai.gai.flow.misc.mem.RuntimeContext;
import kd.ai.gai.flow.script.LifeScriptContext;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.accessor.PathAccessor;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.data.Tuple;
import kd.ai.gai.flow.script.feature.control.advanced.DebuggableContainer;
import kd.ai.gai.flow.script.feature.control.stream.Utils;
import kd.ai.gai.flow.script.parser.Undefined;

public class EachVisitor
extends DebuggableContainer
implements Evaluator {
    private Object src;

    public EachVisitor(Object src, Object tar, int line) {
        super(tar, line);
        this.src = src;
    }

    public Object getSrc() {
        return this.src;
    }

    public Object getTar() {
        return super.directGetBody();
    }

    @Override
    public Object eval(ScriptContext ctx) {
        if (this.src instanceof PathAccessor) {
            PathAccessor.Path path = ((PathAccessor)this.src).path();
            Object src = path.get(ctx, ctx);
            return this.transform(ctx, path, src, ctx);
        }
        Object src = Util.eval(ctx, this.src);
        return this.transform(ctx, src, ctx);
    }

    private Object transform(ScriptContext ctx, PathAccessor.Path path, Object src, ScriptContext root) {
        if (src == null) {
            return null;
        }
        boolean isArray = path.hasFilter();
        if (!path.next()) {
            if (isArray && !Utils.isIterable(src)) {
                return this.transform(ctx, Collections.singletonList(src), root);
            }
            return this.transform(ctx, src, root);
        }
        if (Utils.isIterable(src)) {
            Iterator<?> it = Utils.createIterator(src);
            return this.transformIterator(ctx, path, it, root);
        }
        if (isArray) {
            Iterator<Object> it = Collections.singletonList(src).iterator();
            return this.transformIterator(ctx, path, it, root);
        }
        return this.transformRow(ctx, path, src, root);
    }

    private Object transformRow(ScriptContext ctx, PathAccessor.Path path, Object src, ScriptContext root) {
        LifeScriptContext current = PathAccessor.createScriptContext(ctx, src, root, new Object[0]);
        return this.transform(current, path, path.get(current, root), root);
    }

    private Object transformIterator(ScriptContext ctx, PathAccessor.Path path, Iterator<?> c, ScriptContext root) {
        ArrayList<Object> list = new ArrayList<Object>();
        int index = path.index();
        while (c.hasNext()) {
            Object src = c.next();
            LifeScriptContext current = PathAccessor.createScriptContext(ctx, src, root, new Object[0]);
            Object e = path.get(current, root);
            Object tar = this.transform(current, path, e, root);
            this.appendToList(list, tar, ctx);
            path.reset(index);
        }
        return list;
    }

    private void appendToList(ArrayList<Object> list, Object tar, ScriptContext ctx) {
        if (tar instanceof List) {
            for (Object e : (List)tar) {
                list.add(e);
                MemoryUtil.checkCollectionMemorySize(list, (RuntimeContext)((Object)ctx));
            }
        } else if (tar != Undefined.VALUE) {
            list.add(tar);
            MemoryUtil.checkCollectionMemorySize(list, (RuntimeContext)((Object)ctx));
        }
    }

    private Object transform(ScriptContext ctx, Object src, ScriptContext root) {
        if (src == null) {
            return null;
        }
        if (src instanceof Map) {
            return this.transformMap(ctx, (Map)src, root);
        }
        if (Utils.isIterable(src)) {
            return this.transformList(ctx, src, root);
        }
        return this.transformRow(ctx, src, root);
    }

    private Object transformRow(ScriptContext ctx, Object src, ScriptContext root) {
        LifeScriptContext current = PathAccessor.createScriptContext(ctx, src, root, new Object[0]);
        return Util.eval(current, super.getBody(current));
    }

    private Object transformList(ScriptContext ctx, Object c, ScriptContext root) {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator<?> it = Utils.createIterator(c);
        while (it.hasNext()) {
            Object src = it.next();
            Object tar = this.transformRow(ctx, src, root);
            this.appendToList(list, tar, ctx);
        }
        return list;
    }

    private Object transformMap(ScriptContext ctx, Map<?, ?> src, ScriptContext root) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(src.size());
        for (Map.Entry<?, ?> e : src.entrySet()) {
            Object value = this.transformRow(ctx, e, root);
            if (value instanceof Tuple) {
                Tuple t = (Tuple)value;
                int j = t.size();
                for (int i = 0; i < j; i += 2) {
                    result.put(t.get(i), t.get(i + 1));
                }
                continue;
            }
            if (value instanceof Map.Entry) {
                Map.Entry n = (Map.Entry)value;
                result.put(n.getKey(), n.getValue());
                continue;
            }
            if (value == Undefined.VALUE) continue;
            result.put(e.getKey(), value);
        }
        return result;
    }
}

