/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.control.stream;

import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.io.ObjectReader;
import kd.ai.gai.flow.script.LifeScriptContext;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.feature.control.stream.StreamingVisitor;
import kd.ai.gai.flow.script.parser.Program;

final class StreamingReader
implements ObjectReader<Object> {
    private final Program program;
    private final int totalCount;
    private final LifeScriptContext sctx;
    private final StreamingVisitor visitor;

    StreamingReader(Program program, int totalCount, LifeScriptContext sctx, StreamingVisitor visitor) {
        this.program = program;
        this.totalCount = totalCount;
        this.sctx = sctx;
        this.visitor = visitor;
    }

    @Override
    public Object read() {
        Util.clearSignal(this.sctx);
        if (this.sctx.getProgram() == null) {
            this.sctx.setProgram(this.program);
        }
        try {
            Object object = Util.eval(this.sctx, this.visitor.getItemExpr(this.sctx));
            return object;
        }
        catch (Exception e) {
            throw CommonError.SCRIPT_RUNTIME_ERROR.wrap(e);
        }
        finally {
            Util.clearSignal(this.sctx);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }
}

