/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.op.arith;

import java.util.Collection;
import java.util.Map;
import javax.script.ScriptContext;
import kd.ai.gai.flow.misc.mem.MemoryUtil;
import kd.ai.gai.flow.misc.mem.RuntimeContext;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.core.Operator;

public class AddAll
implements Operator,
NativeFunction {
    @Override
    public String name() {
        return "++=";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object a = args[0];
        Object b = args[1];
        if (a == null) {
            throw new NullPointerException("A is NULL!");
        }
        if (b == null) {
            return Boolean.FALSE;
        }
        if (a instanceof Collection) {
            this.addAll2Collection((Collection)a, b, ctx);
        } else if (a instanceof Map) {
            this.addAll2Map(a, b);
        } else {
            String message = "A is a '" + a.getClass().getName() + "', but B is a '" + b.getClass().getName() + "'.";
            throw new UnsupportedOperationException(message);
        }
        return Boolean.TRUE;
    }

    private void addAll2Map(Object a, Object b) {
        if (b instanceof Map) {
            ((Map)a).putAll((Map)b);
        } else if (b instanceof Collection) {
            Map m = (Map)a;
            for (Map e : (Collection)b) {
                m.put(e.get("key"), e.get("value"));
            }
        } else {
            String message = "A is a Map, but B is a  '" + b.getClass().getName() + "'.";
            throw new UnsupportedOperationException(message);
        }
    }

    private void addAll2Collection(Collection a, Object b, ScriptContext ctx) {
        if (b instanceof Collection) {
            for (Object o : (Collection)b) {
                a.add(o);
                MemoryUtil.checkCollectionMemorySize(a, (RuntimeContext)((Object)ctx));
            }
        } else if (b instanceof Object[]) {
            for (Object o : (Object[])b) {
                a.add(o);
                MemoryUtil.checkCollectionMemorySize(a, (RuntimeContext)((Object)ctx));
            }
        } else {
            String message = "A is Collection, but B is " + b.getClass().getName() + ".";
            throw new UnsupportedOperationException(message);
        }
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public int priority() {
        return 18;
    }
}

