/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.op.arith;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.core.Constructor;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.core.Operator;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.core.Storer;
import kd.ai.gai.flow.script.util.Numeric;

public class Decrement
implements Constructor,
Operator {
    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "--";
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public int type() {
        return 3;
    }

    @Override
    public Object analyze(Statement statement, final Constructor.Position pos) throws ScriptException {
        final Storer ref = (Storer)pos.getOperand(statement, 0);
        return new Evaluator(){

            @Override
            public Object eval(ScriptContext ctx) {
                Object value = Util.eval(ctx, ref);
                Object result = this.subtractOne(value);
                ref.set(ctx, result);
                return pos == Constructor.Position.HEADER ? result : value;
            }

            private Object subtractOne(Object value) {
                Number result;
                if (value == null) {
                    return -1;
                }
                switch (Numeric.getType(value)) {
                    case 6: 
                    case 7: 
                    case 8: {
                        result = ((Number)value).intValue() - 1;
                        break;
                    }
                    case 5: {
                        result = ((Number)value).longValue() - 1L;
                        break;
                    }
                    case 4: {
                        result = ((BigInteger)value).subtract(BigInteger.ONE);
                        break;
                    }
                    case 1: {
                        result = ((BigDecimal)value).subtract(BigDecimal.ONE);
                        break;
                    }
                    case 2: 
                    case 3: {
                        result = ((Number)value).doubleValue() - 1.0;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("--" + value);
                    }
                }
                return result;
            }

            public String toString() {
                return pos == Constructor.Position.HEADER ? Decrement.this.name() + ref : ref + Decrement.this.name();
            }
        };
    }
}

