/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.op.arith;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.core.Negatable;
import kd.ai.gai.flow.script.feature.op.arith.CalcBase;
import kd.ai.gai.flow.script.feature.op.arith.Util;
import kd.ai.gai.flow.script.feature.tool.date.DateAdd;
import kd.ai.gai.flow.script.feature.tool.date.TimeSpan;
import kd.ai.gai.flow.script.util.Numeric;

public final class Subtract
extends CalcBase {
    public static final NativeFunction INS = new Subtract();
    private static final String _name = "-";

    private Subtract() {
    }

    public static Object excludeSubString(Object a, Object b) {
        if (a == null) {
            return null;
        }
        if (b == null) {
            return a;
        }
        String s2 = b.toString();
        if (s2.length() == 0) {
            return a;
        }
        String s1 = a.toString();
        StringBuilder sb = new StringBuilder(s1.length());
        int i = s1.indexOf(s2);
        int j = 0;
        while (i >= 0) {
            sb.append(s1.substring(j, i));
            j = i + s2.length();
            i = s1.indexOf(s2, j);
        }
        if (j < s1.length()) {
            sb.append(s1.substring(j));
        }
        return sb.toString();
    }

    @Override
    protected Object calc(Object[] args) {
        Object a = args[0];
        Object b = args[1];
        if (b == null) {
            return a;
        }
        if (a == null) {
            return Subtract.negate(b);
        }
        if (a instanceof Date) {
            return this.calcDate(args);
        }
        if (a instanceof String) {
            return this.calcString(args);
        }
        if (a instanceof Set && b instanceof Collection) {
            return this.subtractSet((Set)a, (Collection)b);
        }
        if (a instanceof Map && b instanceof Map) {
            return this.subtractMap((Map)a, ((Map)b).keySet());
        }
        if (a instanceof Map && b instanceof Collection) {
            return this.subtractMap((Map)a, (Collection)b);
        }
        return Util.calc(a, b, (NativeFunction)this);
    }

    private Map<?, ?> subtractMap(Map<?, ?> a, Collection<?> keySet) {
        LinkedHashMap map = new LinkedHashMap(a.size());
        map.putAll(a);
        for (Object key : keySet) {
            map.remove(key);
        }
        return map;
    }

    private Object subtractSet(Set<?> ca, Collection<?> cb) {
        HashSet set = new HashSet(ca.size());
        set.addAll(ca);
        set.removeAll(cb);
        return set;
    }

    public static Object negate(Object b) {
        if (b == null) {
            return null;
        }
        if (b instanceof BigDecimal) {
            return ((BigDecimal)b).negate();
        }
        if (b instanceof Integer) {
            return -((Integer)b).intValue();
        }
        if (b instanceof Long) {
            return -((Long)b).longValue();
        }
        if (b instanceof Double) {
            return -((Double)b).doubleValue();
        }
        if (b instanceof Negatable) {
            return ((Negatable)b).negate();
        }
        if (b instanceof BigInteger) {
            return ((BigInteger)b).negate();
        }
        if (b instanceof Short) {
            return -((Short)b).intValue();
        }
        if (b instanceof Byte) {
            return -((Byte)b).intValue();
        }
        if (b instanceof Float) {
            return -((Float)b).doubleValue();
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString("\u4e0d\u80fd\u5bf9\uff08%1$s : %2$s\uff09\u503c\u6c42\u8d1f\u6570\u3002", "Subtract_2", "isc-iscb-util", new Object[0]), b.getClass().getName(), b));
    }

    public Object calcString(Object[] args) {
        Object result = args[0];
        for (int i = 1; i < args.length; ++i) {
            result = Subtract.excludeSubString(result, args[i]);
        }
        return result;
    }

    private Object calcDate(Object[] args) {
        Date a = (Date)args[0];
        Object b = args[1];
        if (b instanceof Date) {
            return a.getTime() - ((Date)b).getTime();
        }
        if (b instanceof TimeSpan) {
            return DateAdd.calc(a, ((TimeSpan)b).negate());
        }
        throw new UnsupportedOperationException(a + " - " + b);
    }

    @Override
    public String name() {
        return _name;
    }

    @Override
    protected Object calc(int a, int b) {
        return a - b;
    }

    @Override
    protected Object calc(long a, long b) {
        return a - b;
    }

    @Override
    protected Object calc(double a, double b) {
        return a - b;
    }

    @Override
    protected BigInteger calc(BigInteger a, BigInteger b) {
        return a.subtract(b);
    }

    @Override
    protected BigDecimal calc(BigDecimal a, BigDecimal b) {
        return a.subtract(b);
    }

    @Override
    protected Object calcSingleValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Numeric.negate((Number)value);
        }
        if (value instanceof Negatable) {
            return ((Negatable)value).negate();
        }
        throw new UnsupportedOperationException(value.getClass().getName() + ":" + value);
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public int priority() {
        return 4;
    }
}

