/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.op.compare;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptContext;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.core.Operator;
import kd.ai.gai.flow.script.core.Predicate;
import kd.ai.gai.flow.script.util.Numeric;

public class Equals
implements NativeFunction,
Operator,
Predicate {
    public static final Equals INS = new Equals();

    private Equals() {
    }

    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "==";
    }

    @Override
    public Boolean call(ScriptContext ctx, Object[] args) {
        Numeric.normalize(args);
        return Equals.equals(args[0], args[1]);
    }

    public static Boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return Boolean.FALSE;
        }
        if (a.equals(b)) {
            return Boolean.TRUE;
        }
        if (a instanceof CharSequence || b instanceof CharSequence) {
            return a.toString().equalsIgnoreCase(b.toString());
        }
        if (a.getClass() == b.getClass() && a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo(b) == 0;
        }
        if (a instanceof Number && b instanceof Number) {
            return Equals.numberEquals(a, b);
        }
        if (a instanceof Map && b instanceof Map) {
            return Equals.mapEquals((Map)a, (Map)b);
        }
        if (a instanceof Set && b instanceof Set) {
            return Equals.setEquals((Set)a, (Set)b);
        }
        if (a instanceof Collection && b instanceof Collection) {
            return Equals.listEquals((Collection)a, (Collection)b);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return Equals.arrayEquals((Object[])a, (Object[])b);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Equals.bytesEquals((byte[])a, (byte[])b);
        }
        return Boolean.FALSE;
    }

    private static Boolean bytesEquals(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Boolean numberEquals(Object a, Object b) {
        Object[] args = new Object[]{a, b};
        Numeric.normalize(args);
        return ((Comparable)args[0]).compareTo(args[1]) == 0;
    }

    private static Boolean arrayEquals(Object[] a, Object[] b) {
        if (a.length != b.length) {
            return Boolean.FALSE;
        }
        int j = a.length;
        for (int i = 0; i < j; ++i) {
            if (Equals.equals(a[i], b[i]).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Boolean listEquals(Collection<?> a, Collection<?> b) {
        if (a.size() != b.size()) {
            return Boolean.FALSE;
        }
        Iterator<?> ia = a.iterator();
        Iterator<?> ib = b.iterator();
        while (ia.hasNext() && ib.hasNext()) {
            if (Equals.equals(ia.next(), ib.next()).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Boolean setEquals(Set<?> a, Set<?> b) {
        if (a.size() != b.size()) {
            return Boolean.FALSE;
        }
        for (Object e : a) {
            if (b.contains(e)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Boolean mapEquals(Map<?, ?> a, Map<?, ?> b) {
        if (a.size() != b.size()) {
            return Boolean.FALSE;
        }
        for (Map.Entry<?, ?> e : a.entrySet()) {
            Object key = e.getKey();
            Object va = e.getValue();
            Object vb = b.get(key);
            if (vb == null && !b.containsKey(key)) {
                return Boolean.FALSE;
            }
            if (Equals.equals(va, vb).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public int priority() {
        return 7;
    }

    @Override
    public int type() {
        return 4;
    }
}

