/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.op.compare;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.core.Constructor;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.core.Operator;
import kd.ai.gai.flow.script.core.Predicate;
import kd.ai.gai.flow.script.core.Reference;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.core.ToolKit;
import kd.ai.gai.flow.script.core.ValueType;
import kd.ai.gai.flow.script.data.Nullable;
import kd.ai.gai.flow.script.parser.Empty;
import kd.ai.gai.flow.script.parser.NotEmpty;
import kd.ai.gai.flow.script.parser.NotNull;
import kd.ai.gai.flow.script.parser.Null;

public class Is
implements Constructor,
Operator {
    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "is";
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        Object operand = Util.getElement(statement, pos, 0);
        Object comparative = Util.getElement(statement, pos, 1);
        return new IsTest(comparative, operand);
    }

    public static boolean testEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() == 0;
        }
        if (value instanceof Map) {
            return ((Map)value).size() == 0;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() == 0;
        }
        if (value instanceof Nullable) {
            return ((Nullable)value).isNull();
        }
        return false;
    }

    @Override
    public int priority() {
        return 6;
    }

    @Override
    public int type() {
        return 4;
    }

    private static final class IsTest
    implements Evaluator,
    Predicate {
        private final Object comparative;
        private final Object operand;

        private IsTest(Object comparative, Object operand) {
            this.comparative = comparative;
            this.operand = operand;
        }

        @Override
        public Object eval(ScriptContext ctx) {
            Object comp;
            Object value = Util.eval(ctx, this.operand);
            Object object = comp = this.comparative instanceof Reference ? Util.eval(ctx, this.comparative) : this.comparative;
            if (comp instanceof Null || comp == null) {
                return value == null;
            }
            if (comp == NotNull.VALUE) {
                return value != null;
            }
            if (comp instanceof Empty) {
                return Is.testEmpty(value);
            }
            if (comp instanceof NotEmpty) {
                return !Is.testEmpty(value);
            }
            if (comp instanceof Class) {
                Class cls = (Class)this.comparative;
                return cls.isInstance(value);
            }
            if (comp instanceof ToolKit) {
                return ((ToolKit)comp).isFor(value);
            }
            if (comp instanceof ValueType) {
                return ((ValueType)comp).isInstance(value);
            }
            throw new UnsupportedOperationException(value + " not supports 'is " + this.comparative + "(" + comp.getClass().getName() + ")' test!");
        }

        public String toString() {
            return this.operand + " is " + this.comparative;
        }
    }
}

