/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.sql;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.script.ScriptContext;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.db.DataTypeUtil;
import kd.ai.gai.flow.db.DbUtil;
import kd.ai.gai.flow.dt.DataType;
import kd.ai.gai.flow.err.DatabaseError;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.misc.Pair;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.feature.op.compare.Is;
import kd.ai.gai.flow.script.feature.sql.SelectParser;
import kd.ai.gai.flow.script.feature.sql.SqlRuntime;
import kd.ai.gai.flow.script.feature.sql.ValueReader;

public class SelectExecutor
implements Evaluator {
    private String sql;
    private ValueReader[] single_readers;
    private ValueReader[] multi_readers;
    private Object connStub;
    private List<Object> params;
    private List<Integer> types;

    public SelectExecutor(String sql, List<ValueReader> readers, Object connStub, List<Object> params, List<Integer> types) {
        this.sql = sql;
        this.connStub = connStub;
        this.params = params;
        this.types = types;
        this.prepareReaders(readers);
    }

    private void prepareReaders(List<ValueReader> readers) {
        ArrayList<ValueReader> single_readers = new ArrayList<ValueReader>();
        ArrayList<ValueReader> multi_readers = new ArrayList<ValueReader>();
        for (ValueReader reader : readers) {
            if (reader.isArray()) {
                multi_readers.add(reader);
                continue;
            }
            single_readers.add(reader);
        }
        this.single_readers = single_readers.toArray(new ValueReader[single_readers.size()]);
        this.multi_readers = multi_readers.toArray(new ValueReader[multi_readers.size()]);
    }

    @Override
    public Object eval(ScriptContext ctx) {
        Object object;
        ArrayList<Object> values = new ArrayList<Object>(this.params.size());
        ArrayList<Integer> types = new ArrayList<Integer>(this.params.size());
        String sql = this.prepareParameters(ctx, this.sql, values, types);
        PreparedStatement ps = this.prepareStatement(ctx, sql);
        ResultSet rs = null;
        try {
            Object result;
            DbUtil.setParameters(ps, values, types);
            rs = ps.executeQuery();
            object = result = this.assembleResult(ctx, rs);
        }
        catch (SQLException e) {
            try {
                throw DatabaseError.SQL_QUERY_FAILURE.wrap(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(ps, rs);
                throw throwable;
            }
        }
        DbUtil.close(ps, rs);
        return object;
    }

    private Object assembleResult(ScriptContext ctx, ResultSet rs) throws SQLException {
        if (this.hasNoReaders()) {
            return DbUtil.toList(rs);
        }
        return this.readData(ctx, rs);
    }

    private boolean hasNoReaders() {
        return this.single_readers.length == 0 && this.multi_readers.length == 0;
    }

    private PreparedStatement prepareStatement(ScriptContext ctx, String sql) {
        try {
            Connection cn = this.getConnection(ctx);
            return cn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw DatabaseError.PREPARED_STATEMENT_FAILURE.create(e, sql);
        }
    }

    private boolean readData(ScriptContext ctx, ResultSet rs) throws SQLException {
        if (rs.next()) {
            this.returnRow(ctx, rs);
            this.returnList(ctx, rs);
            return true;
        }
        this.returnNull(ctx);
        return false;
    }

    private Connection getConnection(ScriptContext ctx) {
        if (this.connStub == null) {
            Connection cn = SqlRuntime.getCurrent();
            if (cn != null) {
                return cn;
            }
            throw new IscBizException(ResManager.loadKDString("\u5f53\u524d\u73af\u5883\u6ca1\u6709\u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5\uff01", "SelectExecutor_0", "isc-iscb-util", new Object[0]));
        }
        Connection cn = (Connection)Util.eval(ctx, this.connStub);
        if (cn != null) {
            return cn;
        }
        throw new IscBizException(String.format(ResManager.loadKDString("\u5f53\u524d\u73af\u5883\u6ca1\u6709\u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5\u201c%s\u201d\uff01", "SelectExecutor_2", "isc-iscb-util", new Object[0]), this.connStub));
    }

    private String prepareParameters(ScriptContext ctx, String sql, List<Object> values, List<Integer> types) {
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            Object value = this.getParamValue(ctx, i);
            sql = Is.testEmpty(value) ? SelectParser.replace(sql, i, "null") : (value instanceof Collection ? this.replaceParamWithCollection(sql, i, (Collection)value, values, types) : (value.getClass().isArray() ? this.replaceParamWithCollection(sql, i, this.arrayToList(value), values, types) : this.replaceParamWithSingleValue(sql, i, value, values, types)));
        }
        return sql;
    }

    private List<Object> arrayToList(Object array) {
        int count = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(count);
        for (int index = 0; index < count; ++index) {
            list.add(Array.get(array, index));
        }
        return list;
    }

    private String replaceParamWithCollection(String sql, int paramIndex, Collection<?> list, List<Object> values, List<Integer> types) {
        Pair<Integer, Object> param = new Pair<Integer, Object>(this.types.get(paramIndex), null);
        StringBuilder placeHolder = new StringBuilder();
        for (Object value : list) {
            if (placeHolder.length() > 0) {
                placeHolder.append(", ");
            }
            if (value == null) {
                placeHolder.append("NULL");
                continue;
            }
            param = this.appendParamValue(values, types, placeHolder, param, value);
        }
        sql = SelectParser.replace(sql, paramIndex, placeHolder.toString());
        return sql;
    }

    private Pair<Integer, DataType> appendParamValue(List<Object> values, List<Integer> types, StringBuilder placeHolder, Pair<Integer, DataType> param, Object value) {
        param = this.checkDataType(param, value);
        DataType dt = param.getValue();
        placeHolder.append('?');
        Object innerValue = dt.forSave(dt.narrow(value));
        values.add(innerValue);
        Integer type = param.getKey();
        types.add(type);
        return param;
    }

    private Pair<Integer, DataType> checkDataType(Pair<Integer, DataType> param, Object value) {
        if (param.getValue() == null) {
            Integer type = param.getKey();
            if (type == null) {
                type = DataTypeUtil.getSqlType(value);
            }
            DataType dt = DataTypeUtil.getDataType(type);
            param = new Pair<Integer, DataType>(type, dt);
        }
        return param;
    }

    private String replaceParamWithSingleValue(String sql, int paramIndex, Object value, List<Object> values, List<Integer> types) {
        Integer type = this.types.get(paramIndex);
        if (type == null) {
            type = DataTypeUtil.getSqlType(value);
        }
        DataType dt = DataTypeUtil.getDataType(type);
        value = dt.forSave(dt.narrow(value));
        values.add(value);
        types.add(type);
        sql = SelectParser.replace(sql, paramIndex, "?");
        return sql;
    }

    private void returnList(ScriptContext ctx, ResultSet rs) throws SQLException {
        List<Object>[] list = this.prepareBuffer(ctx);
        if (list.length == 0) {
            return;
        }
        do {
            this.readRow(list, rs);
        } while (rs.next());
    }

    private List<Object>[] prepareBuffer(ScriptContext ctx) {
        List[] list = new List[this.multi_readers.length];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new ArrayList();
            ValueReader reader = this.multi_readers[i];
            reader.getAssign().set(ctx, list[i]);
        }
        return list;
    }

    private void readRow(List<Object>[] list, ResultSet rs) throws SQLException {
        for (int i = 0; i < list.length; ++i) {
            ValueReader reader = this.multi_readers[i];
            Object value = reader.read(rs);
            list[i].add(value);
        }
    }

    private void returnRow(ScriptContext ctx, ResultSet rs) throws SQLException {
        for (ValueReader reader : this.single_readers) {
            Object value = reader.read(rs);
            reader.getAssign().set(ctx, value);
        }
    }

    private void returnNull(ScriptContext ctx) {
        for (ValueReader reader : this.single_readers) {
            reader.getAssign().set(ctx, null);
        }
        for (ValueReader reader : this.multi_readers) {
            reader.getAssign().set(ctx, new ArrayList(0));
        }
    }

    private Object getParamValue(ScriptContext ctx, int i) {
        Object value = Util.eval(ctx, this.params.get(i));
        if (value instanceof Date) {
            value = new Timestamp(((Date)value).getTime());
        } else if (value instanceof CharSequence) {
            value = value.toString();
        }
        return value;
    }

    public String toString() {
        return this.sql;
    }
}

