/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.sql;

import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptException;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.script.accessor.PathAccessor;
import kd.ai.gai.flow.script.core.AccessorByName;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.core.Identifier;
import kd.ai.gai.flow.script.core.Operator;
import kd.ai.gai.flow.script.core.ReferenceA;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.core.Storer;
import kd.ai.gai.flow.script.feature.op.store.Assign;
import kd.ai.gai.flow.script.feature.sql.SelectExecutor;
import kd.ai.gai.flow.script.feature.sql.ValueReader;
import kd.ai.gai.flow.script.statement.Arguments;
import kd.ai.gai.flow.script.statement.Block;

class SelectParser {
    private Statement statement;
    private StringBuilder sql = new StringBuilder();
    private List<ValueReader> readers = new ArrayList<ValueReader>();
    private Object connStub = null;
    private List<Object> params = new ArrayList<Object>();
    private List<Integer> types = new ArrayList<Integer>();
    private int index = 1;
    private int column = 0;
    private int size;

    SelectParser(Statement statement) {
        this.statement = statement;
        this.size = statement.length();
    }

    SelectExecutor parse() throws ScriptException {
        this.sql.append("SELECT ");
        this.parseFields();
        this.sql.append(" FROM ");
        this.index = this.findConnStub(this.statement, this.index);
        this.appendTail(this.statement, this.index);
        return new SelectExecutor(this.sql.toString(), this.readers, this.connStub, this.params, this.types);
    }

    private int findConnStub(Statement statement, int index) throws ScriptException {
        int size = statement.length();
        Object e = statement.get(index);
        if (e instanceof Statement) {
            Statement smt = (Statement)e;
            this.sql.append('(');
            int i = this.skipToFrom(smt, 0);
            i = this.findConnStub(smt, i);
            this.appendTail(smt, i);
            this.sql.append(") ");
            ++index;
        } else if (index + 1 < size && statement.get(index + 1) instanceof AccessorByName) {
            this.connStub = e;
            index += 2;
        }
        return index;
    }

    private int appendElement(Object e, Statement statement, int index) throws ScriptException {
        if (e instanceof String) {
            this.appendParam((String)e);
            ++index;
        } else if (this.isVarReference(e)) {
            index = this.appendVarParam(statement, e, index);
        } else if (e instanceof Statement) {
            this.appendSubClause((Statement)e);
            ++index;
        } else if (e instanceof Identifier) {
            String name = ((Identifier)e).name();
            if (name.equalsIgnoreCase("INTO")) {
                throw new IscBizException(ResManager.loadKDString("SQL\u8bed\u53e5\u4e2d\u4e0d\u5141\u8bb8\u5305\u542bINTO\u5173\u952e\u5b57", "SelectParser_0", "isc-iscb-util", new Object[0]));
            }
            this.sql.append(name);
            ++index;
        } else {
            this.sql.append(e);
            ++index;
        }
        this.sql.append(' ');
        return index;
    }

    private void appendTail(Statement statement, int index) throws ScriptException {
        int size = statement.length();
        while (index < size) {
            Object e = statement.get(index);
            index = this.appendElement(e, statement, index);
        }
    }

    private int skipToFrom(Statement statement, int index) throws ScriptException {
        int size = statement.length();
        while (index < size) {
            Object e = statement.get(index);
            index = this.appendElement(e, statement, index);
            if (!this.isFromKeyword(e)) continue;
            break;
        }
        return index;
    }

    private boolean isFromKeyword(Object e) {
        if (!(e instanceof Identifier)) {
            return false;
        }
        String name = ((Identifier)e).name();
        return "FROM".equalsIgnoreCase(name);
    }

    private boolean isVarReference(Object e) {
        return e instanceof PathAccessor || e instanceof ReferenceA;
    }

    private void appendSubClause(Statement e) throws ScriptException {
        this.sql.append('(');
        this.appendTail(e, 0);
        this.sql.append(") ");
    }

    private void parseFields() throws ScriptException {
        while (this.index < this.size) {
            Object e = this.statement.get(this.index);
            if (this.isFromKeyword(e)) {
                ++this.index;
                break;
            }
            if (this.isVarReference(e)) {
                this.createReader(e);
                this.index += 3;
            } else if (e instanceof String) {
                this.appendParam((String)e);
                ++this.index;
            } else if (e instanceof Statement) {
                this.appendSubClause((Statement)e);
                ++this.index;
            } else {
                if (e instanceof Assign) {
                    throw new ScriptException(String.format(ResManager.loadKDString(" \u5b57\u6bb5\u90e8\u5206\u51fa\u73b0\u4e86\u8d4b\u503c\u7b26\u53f7\uff08=\uff09\uff0c\u4f46\u5176\u524d\u4e00\u4e2a\u5143\u7d20\uff08%s\uff09\u4e0d\u662f\u4ee5\u4e24\u4e2a @@ \u5f00\u5934\u3002", "SelectParser_8", "isc-iscb-util", new Object[0]), this.statement.get(this.index - 1)));
                }
                this.index = this.appendElement(e, this.statement, this.index);
            }
            this.sql.append(' ');
        }
    }

    private void createReader(Object var) throws ScriptException {
        this.checkRequiredAssignOperator(var);
        Object field = this.statement.get(this.index + 2);
        Storer storer = this.createStorer(this.statement, var);
        List<Integer> columns = this.collectColumns(field);
        this.readers.add(new ValueReader(storer, columns, this.isArray(var.toString())));
    }

    private void checkRequiredAssignOperator(Object var) throws ScriptException {
        if (!(this.statement.get(this.index + 1) instanceof Assign)) {
            throw new ScriptException(String.format(ResManager.loadKDString("\u201c%s\u201d\u540e\u4e0d\u662f\u8981\u6c42\u7684\u7b49\u53f7\uff08=\uff09\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u9057\u6f0f\u4e86\u7a7a\u683c\u5206\u9694\u7b26\uff01", "SelectParser_9", "isc-iscb-util", new Object[0]), var));
        }
    }

    private boolean isArray(String path) {
        return path.endsWith("[]");
    }

    private List<Integer> collectColumns(Object field) throws ScriptException {
        ArrayList<Integer> columns = new ArrayList<Integer>();
        if (field instanceof Arguments) {
            Arguments fields = (Arguments)field;
            this.column = this.appendFields(this.sql, fields, this.column, this.params, this.types, columns);
        } else {
            ++this.column;
            this.sql.append(field);
            columns.add(this.column);
        }
        return columns;
    }

    private Storer createStorer(Statement statement, Object e) throws ScriptException {
        String ref = e.toString();
        this.checkCtxRefencePrefix(ref);
        String var = this.isArray(ref) ? ref.substring(1, ref.length() - 2) : ref.substring(1);
        Object storer = ((Block)statement.getEngine().compile(var, statement.getContext()).getImpl()).get(0);
        if (storer instanceof Storer) {
            return (Storer)storer;
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString("\u8bf7\u52ff\u4f7f\u7528\uff08%s\uff09\u4f5c\u4e3a\u811a\u672c\u53d8\u91cf\u540d\uff01", "SelectParser_10", "isc-iscb-util", new Object[0]), var));
    }

    private void checkCtxRefencePrefix(String ref) {
        if (!ref.startsWith("@")) {
            throw new IscBizException(String.format(ResManager.loadKDString("\u201c%s\u201d\u5fc5\u987b\u4ee5\u4e24\u4e2a@@\u5f00\u5934\uff01", "SelectParser_11", "isc-iscb-util", new Object[0]), ref));
        }
    }

    private Evaluator createEvaluator(Statement statement, Object e) throws ScriptException {
        String ref = e.toString();
        this.checkCtxRefencePrefix(ref);
        String var = ref.substring(1);
        Evaluator storer = (Evaluator)((Block)statement.getEngine().compile(var).getImpl()).get(0);
        return storer;
    }

    private int appendFields(StringBuilder sql, Arguments fields, int column, List<Object> params, List<Integer> types, List<Integer> columns) throws ScriptException {
        if (fields.length() == 0) {
            throw new IllegalArgumentException(ResManager.loadKDString("\u62ec\u53f7\u5185\u6ca1\u6709\u6307\u5b9a\u5b57\u6bb5\u5217\u8868\uff01", "SelectParser_7", "isc-iscb-util", new Object[0]));
        }
        columns.add(++column);
        for (int j = 0; j < fields.length(); ++j) {
            Object f = fields.get(j);
            if (f instanceof String) {
                this.appendParam((String)f);
            } else if (f instanceof Arguments) {
                this.appendSubClause((Arguments)f);
            } else {
                sql.append(f);
            }
            if (f == Operator.COMMA) {
                columns.add(++column);
            }
            sql.append(' ');
        }
        return column;
    }

    private void appendParam(String s) {
        int paramIndex = this.params.size();
        this.sql.append(SelectParser.generateParamMark(paramIndex));
        this.params.add(s);
        this.types.add(12);
    }

    private int appendVarParam(Statement statement, Object e, int index) throws ScriptException {
        int paramIndex = this.params.size();
        this.sql.append(SelectParser.generateParamMark(paramIndex));
        this.params.add(this.createEvaluator(statement, e));
        index = this.setVarParamType(statement, index);
        return index;
    }

    private static String generateParamMark(int paramIndex) {
        return " #{" + paramIndex + "} ";
    }

    private int setVarParamType(Statement statement, int index) {
        if (index + 3 < statement.length() && statement.get(index + 1) == Operator.COLON && statement.get(index + 2) == Operator.COLON) {
            this.types.add((Integer)statement.get(index + 3));
            index += 4;
        } else {
            this.types.add(null);
            ++index;
        }
        return index;
    }

    public static String replace(String sql, int paramIndex, String placeHolder) {
        String pattern = SelectParser.generateParamMark(paramIndex);
        int i = sql.indexOf(pattern);
        int j = i + pattern.length();
        return sql.substring(0, i) + placeHolder + sql.substring(j);
    }
}

