/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.data;

import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptContext;
import kd.ai.gai.flow.misc.Pair;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.data.fsm.Action;
import kd.ai.gai.flow.script.data.fsm.FSM;

public final class FsmBuilder
implements NativeFunction {
    @Override
    public String name() {
        return "fsm";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        FSMWrapper wrapper = new FSMWrapper();
        if (args[0] instanceof Map) {
            this.createFSM4Action(args, wrapper);
        } else {
            this.createFSM4Search(args, wrapper);
        }
        return wrapper;
    }

    private void createFSM4Search(Object[] args, FSMWrapper wrapper) {
        for (Object s : args) {
            wrapper.fsm.add(s.toString());
        }
    }

    private void createFSM4Action(Object[] args, FSMWrapper wrapper) {
        HashMap<NativeFunction, Action> actions = new HashMap<NativeFunction, Action>();
        for (Map.Entry<String, NativeFunction> entry : ((Map)args[0]).entrySet()) {
            String pattern = (String)entry.getKey();
            NativeFunction fn = (NativeFunction)entry.getValue();
            Action action = this.getAction(actions, entry, fn);
            wrapper.fsm.add(pattern, action);
        }
    }

    private Action getAction(HashMap<NativeFunction, Action> actions, Map.Entry<String, NativeFunction> entry, NativeFunction fn) {
        Action action = actions.get(fn);
        if (action == null) {
            action = new ActionAdapter(entry.getValue());
            actions.put(fn, action);
        }
        return action;
    }

    private static final class ActionAdapter
    implements Action {
        private NativeFunction fn;

        ActionAdapter(NativeFunction fn) {
            this.fn = fn;
        }

        @Override
        public void doAction(String input, Object param, String pattern) {
            Pair pair = (Pair)param;
            Object[] args = new Object[]{input, pair.getB(), pattern};
            this.fn.call((ScriptContext)pair.getA(), args);
        }
    }

    private static final class FSMWrapper
    implements NativeFunction {
        private FSM fsm = new FSM();

        private FSMWrapper() {
        }

        @Override
        public String name() {
            return "fsm";
        }

        @Override
        public Object call(ScriptContext ctx, Object[] args) {
            String input = args[0].toString();
            if (args.length == 1) {
                return this.fsm.exec(input, new Pair<ScriptContext, Object>(ctx, null));
            }
            return this.fsm.exec(input, new Pair<ScriptContext, Object>(ctx, args[1]));
        }
    }
}

