/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.data.sls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.ai.gai.flow.script.feature.tool.data.sls.Feature;

public final class Element {
    private Object id;
    private Map<Object, Set<Feature>> features;
    private double weight;

    public Element(Object id, Feature ... features) {
        this.id = id;
        this.features = new HashMap<Object, Set<Feature>>();
        for (Feature f : features) {
            Object group = f.getGroup();
            Set<Feature> set = this.features.get(group);
            if (set == null) {
                set = new HashSet<Feature>();
                this.features.put(group, set);
            }
            set.add(f);
        }
    }

    public Object getId() {
        return this.id;
    }

    public double getWeight() {
        return this.weight;
    }

    void setWeight(double weight) {
        this.weight = weight;
    }

    public Feature[] getFeatures(Object group) {
        Set<Feature> set = this.features.get(group);
        if (set == null) {
            return new Feature[0];
        }
        return set.toArray(new Feature[set.size()]);
    }

    public ArrayList<Feature> getFeatures() {
        ArrayList<Feature> list = new ArrayList<Feature>();
        for (Set<Feature> set : this.features.values()) {
            list.addAll(set);
        }
        return list;
    }

    public String toString() {
        return this.id + " : " + this.features;
    }
}

