/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.data.sls;

import java.util.Map;
import kd.ai.gai.flow.script.feature.tool.data.sls.Element;
import kd.ai.gai.flow.script.feature.tool.data.sls.Feature;

class Util {
    Util() {
    }

    private static boolean[][] GenerateMatrix(Object group, Map<Feature, Integer> features, Element[] elements) {
        int i;
        boolean[][] classes = new boolean[features.size()][];
        for (i = 0; i < classes.length; ++i) {
            classes[i] = new boolean[elements.length];
        }
        for (i = 0; i < elements.length; ++i) {
            for (Feature f : elements[i].getFeatures(group)) {
                int j = features.get(f);
                classes[j][i] = true;
            }
        }
        return classes;
    }

    private static long[][] createMatrix(int m) {
        long[][] matrix = new long[m][];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = new long[m];
        }
        return matrix;
    }

    static long gcd(long a, long b) {
        long r = b;
        do {
            b = r;
            r = a % b;
            a = b;
        } while (r != 0L);
        return b;
    }

    static void CalcWeights(Object group, Map<Feature, Integer> features, Element[] elements) {
        int i;
        boolean[][] classes = Util.GenerateMatrix(group, features, elements);
        double[] propertions = new double[features.size()];
        for (Map.Entry<Feature, Integer> entry : features.entrySet()) {
            double p;
            propertions[entry.getValue().intValue()] = p = entry.getKey().getProportion();
        }
        int m = classes.length + 1;
        int n = classes[0].length;
        long[][] matrix = Util.createMatrix(m);
        double[] b = new double[m];
        for (i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                matrix[i][j] = 0L;
            }
        }
        System.arraycopy(propertions, 0, b, 0, m - 1);
        b[m - 1] = 1.0;
        for (i = 0; i < m - 1; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!classes[i][j]) continue;
                long[] lArray = matrix[i];
                int n2 = m - 1;
                lArray[n2] = lArray[n2] + 1L;
                for (int k = 0; k < m - 1; ++k) {
                    if (!classes[k][j]) continue;
                    long[] lArray2 = matrix[i];
                    int n3 = k;
                    lArray2[n3] = lArray2[n3] + 1L;
                }
            }
        }
        for (i = 0; i < m - 1; ++i) {
            matrix[m - 1][i] = matrix[i][i];
        }
        matrix[m - 1][m - 1] = n;
        for (i = 0; i < m - 1; ++i) {
            if (matrix[i][i] == 0L) continue;
            for (int j = i + 1; j < m; ++j) {
                if (matrix[j][i] == 0L) continue;
                long gcd = Util.gcd(matrix[i][i], matrix[j][i]);
                long p = matrix[j][i] / gcd;
                long q = matrix[i][i] / gcd;
                matrix[j][i] = 0L;
                b[j] = b[j] * (double)q - b[i] * (double)p;
                for (int k = j; k < m; ++k) {
                    matrix[j][k] = matrix[j][k] * q - matrix[i][k] * p;
                }
            }
        }
        for (i = m - 1; i >= 0; --i) {
            if (matrix[i][i] == 0L) {
                b[i] = 0.0;
                continue;
            }
            for (int j = m - 1; j > i; --j) {
                int n4 = i;
                b[n4] = b[n4] - b[j] * (double)matrix[i][j];
            }
            int n5 = i;
            b[n5] = b[n5] / (double)matrix[i][i];
        }
        for (int j = 0; j < n; ++j) {
            double w = b[m - 1];
            for (i = 0; i < m - 1; ++i) {
                if (!classes[i][j]) continue;
                w += b[i];
            }
            Element candidate = elements[j];
            if (w <= 0.0) {
                throw new IllegalArgumentException("A weight value is less than zero. w = " + w);
            }
            candidate.setWeight(candidate.getWeight() * w);
        }
    }

    boolean[][] GenerateMatrix(Map<Feature, Integer> features, Element[] elements) {
        int i;
        boolean[][] classes = new boolean[features.size()][];
        for (i = 0; i < classes.length; ++i) {
            classes[i] = new boolean[elements.length];
        }
        for (i = 0; i < elements.length; ++i) {
            for (Feature f : elements[i].getFeatures()) {
                int j = features.get(f);
                classes[j][i] = true;
            }
        }
        return classes;
    }
}

