/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.date;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.script.ScriptContext;
import kd.ai.gai.flow.script.core.Evaluator;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.data.ValueRange;
import kd.ai.gai.flow.script.feature.tool.date.DateToolKit;

public class DateRange
implements NativeFunction {
    protected static DateRange INS = new DateRange();
    protected static final Evaluator RANGE_TODAY = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            return DateRange.calc(DateToolKit.DAY, new Date());
        }
    };
    protected static final Evaluator RANGE_YESTERDAY = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            return DateRange.calc(DateToolKit.DAY, new Date(System.currentTimeMillis() - 86400000L));
        }
    };
    protected static final Evaluator RANGE_TOMORROW = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            return DateRange.calc(DateToolKit.DAY, new Date(System.currentTimeMillis() + 86400000L));
        }
    };
    protected static final Evaluator RANGE_THIS_WEEK = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            return DateRange.calc(DateToolKit.WEEK, new Date());
        }
    };
    protected static final Evaluator RANGE_LAST_WEEK = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            return DateRange.calc(DateToolKit.WEEK, new Date(System.currentTimeMillis() - 604800000L));
        }
    };
    protected static final Evaluator RANGE_NEXT_WEEK = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            return DateRange.calc(DateToolKit.WEEK, new Date(System.currentTimeMillis() + 604800000L));
        }
    };
    protected static final Evaluator RANGE_THIS_MONTH = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            return DateRange.calc(DateToolKit.MONTH, new Date());
        }
    };
    protected static final Evaluator RANGE_LAST_MONTH = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            Calendar date = Calendar.getInstance();
            date.add(2, -1);
            return DateRange.calc(DateToolKit.MONTH, date);
        }
    };
    protected static final Evaluator RANGE_NEXT_MONTH = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            Calendar date = Calendar.getInstance();
            date.add(2, 1);
            return DateRange.calc(DateToolKit.MONTH, date);
        }
    };
    protected static final Evaluator RANGE_THIS_QUARTER = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            return DateRange.calc(DateToolKit.QUARTER, new Date());
        }
    };
    protected static final Evaluator RANGE_LAST_QUARTER = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            Calendar date = Calendar.getInstance();
            date.add(2, -3);
            return DateRange.calc(DateToolKit.QUARTER, date);
        }
    };
    protected static final Evaluator RANGE_NEXT_QUARTER = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            Calendar date = Calendar.getInstance();
            date.add(2, 3);
            return DateRange.calc(DateToolKit.QUARTER, date);
        }
    };
    protected static final Evaluator RANGE_THIS_YEAR = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            return DateRange.calc(DateToolKit.YEAR, new Date());
        }
    };
    protected static final Evaluator RANGE_LAST_YEAR = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            Calendar date = Calendar.getInstance();
            date.add(1, -1);
            return DateRange.calc(DateToolKit.YEAR, date);
        }
    };
    protected static final Evaluator RANGE_NEXT_YEAR = new Evaluator(){

        @Override
        public Object eval(ScriptContext ctx) {
            Calendar date = Calendar.getInstance();
            date.add(1, 1);
            return DateRange.calc(DateToolKit.YEAR, date);
        }
    };

    @Override
    public String name() {
        return "range";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object type = args[0];
        Object v = args.length == 1 ? null : args[1];
        return DateRange.calc(type, v);
    }

    public static ValueRange<Date> calc(Object type, Object d) {
        Timestamp end;
        java.sql.Date start;
        Calendar date = d instanceof Calendar ? (Calendar)d : Calendar.getInstance();
        if (d instanceof Date) {
            date.setTime((Date)d);
        }
        date.set(14, 0);
        date.set(13, 0);
        date.set(12, 0);
        date.set(11, 0);
        if (type == DateToolKit.MONTH) {
            date.set(5, 1);
            start = new java.sql.Date(date.getTime().getTime());
            date.add(2, 1);
            date.add(14, -1);
            end = new Timestamp(date.getTime().getTime());
        } else if (type == DateToolKit.WEEK) {
            int dw = date.get(7) - 1;
            if (dw != 0) {
                date.add(5, -dw);
            }
            start = new java.sql.Date(date.getTime().getTime());
            date.add(5, 7);
            date.add(14, -1);
            end = new Timestamp(date.getTime().getTime());
        } else if (type == DateToolKit.YEAR) {
            date.set(5, 1);
            date.set(2, 0);
            start = new java.sql.Date(date.getTime().getTime());
            date.add(1, 1);
            date.add(14, -1);
            end = new Timestamp(date.getTime().getTime());
        } else if (type == DateToolKit.QUARTER) {
            int month = date.get(2) / 3 * 3;
            date.set(5, 1);
            date.set(2, month);
            start = new java.sql.Date(date.getTime().getTime());
            date.add(2, 3);
            date.add(14, -1);
            end = new Timestamp(date.getTime().getTime());
        } else if (type == DateToolKit.DAY) {
            start = new java.sql.Date(date.getTime().getTime());
            date.add(5, 1);
            date.add(14, -1);
            end = new Timestamp(date.getTime().getTime());
        } else {
            throw new UnsupportedOperationException();
        }
        return new ValueRange<Date>(start, end);
    }
}

