/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.hash;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.script.ScriptContext;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.script.core.NativeFunction;

public class HMAC_SHA256
implements NativeFunction {
    private static final String HMAC_SHA_256 = "HmacSHA256";

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object value = args[0];
        Object key = args[1];
        if (value == null || key == null) {
            throw new IllegalArgumentException(ResManager.loadKDString("\u53c2\u6570\u4e0d\u80fd\u4e3anull\u503c", "HMAC_SHA256_0", "isc-iscb-util", new Object[0]));
        }
        Mac mac = this.getMacInstance();
        this.initMac(key, mac);
        byte[] bytes = mac.doFinal(D.s(value).getBytes(D.UTF_8));
        return this.toHexString(bytes);
    }

    private void initMac(Object key, Mac mac) {
        SecretKeySpec signingKey = new SecretKeySpec(key.toString().getBytes(D.UTF_8), HMAC_SHA_256);
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw CommonError.INVALID_HASH_INIT_KEY.wrap(e);
        }
    }

    private Mac getMacInstance() {
        try {
            return Mac.getInstance(HMAC_SHA_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw CommonError.NO_SUCH_HASH_ALGO.create(e, HMAC_SHA_256);
        }
    }

    private String toHexString(byte[] bytes) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; bytes != null && n < bytes.length; ++n) {
            String stmp = Integer.toHexString(bytes[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    @Override
    public String name() {
        return "HMAC_SHA256";
    }
}

