/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.number;

import javax.script.ScriptContext;
import kd.ai.gai.flow.script.core.NativeFunction;

public class FormatPercent
implements NativeFunction {
    private static final double ZERO = 0.0;

    @Override
    public String name() {
        return "%";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Number n = (Number)args[0];
        if (n == null) {
            return null;
        }
        if (args.length == 2) {
            return FormatPercent.format(n, (Number)args[1]);
        }
        return FormatPercent.format(n.doubleValue());
    }

    public static String format(Number v1, Number v2) {
        if (v1 == null || v2 == null) {
            return null;
        }
        double compared = v2.doubleValue();
        if (compared == 0.0) {
            return null;
        }
        double diff = (v1.doubleValue() - compared) / Math.abs(compared);
        return FormatPercent.format(diff);
    }

    public static String format(double diff) {
        String s = String.valueOf(Math.round(Math.abs(diff) * 10000.0));
        switch (s.length()) {
            case 1: {
                return diff >= 0.0 ? "0.0" + s : "-0.0" + s;
            }
            case 2: {
                return diff >= 0.0 ? "0." + s : "-0." + s;
            }
        }
        int intPart = s.length() - 2;
        String result = s.substring(0, intPart) + "." + s.substring(intPart);
        return diff >= 0.0 ? result : "-" + result;
    }
}

