/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.number;

import java.math.BigInteger;
import javax.script.ScriptContext;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.encoding.Encoding;

public class ParseHex
implements NativeFunction {
    @Override
    public String name() {
        return "parseHex";
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object n;
        Object object = n = args.length == 0 ? null : args[0];
        if (n == null) {
            return null;
        }
        if (n instanceof Number) {
            return n;
        }
        String s = n.toString();
        if (s.length() <= 16) {
            return ParseHex.parseLong(s);
        }
        return ParseHex.parseBigInteger(s);
    }

    public static BigInteger parseBigInteger(String s) {
        byte[] bytes = Encoding.HEX.decode(s.getBytes(D.UTF_8));
        return new BigInteger(bytes);
    }

    public static long parseLong(String s) {
        byte[] bytes = Encoding.HEX.decode(s.getBytes(D.UTF_8));
        if (bytes.length > 8) {
            throw new IscBizException(s + " is too big.");
        }
        long v = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            v = v << 8 | (long)(0xFF & bytes[i]);
        }
        return v;
    }
}

