/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.script.ScriptContext;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.script.core.NativeFunction;

public class Round
implements NativeFunction {
    @Override
    public String name() {
        return "round";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        BigDecimal value = Round.cast(args[0]);
        if (value == null) {
            return null;
        }
        int scale = this.getScale(args);
        if (scale == value.scale()) {
            return value;
        }
        return value.setScale(scale, RoundingMode.HALF_UP);
    }

    private int getScale(Object[] args) {
        return args.length == 1 ? 0 : ((Number)args[1]).intValue();
    }

    static BigDecimal cast(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Number) {
            return Round.castNumber((Number)v);
        }
        return Round.parseNumberString(D.s(v));
    }

    private static BigDecimal castNumber(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof Double) {
            return BigDecimal.valueOf(n.doubleValue());
        }
        if (n instanceof Float) {
            return BigDecimal.valueOf(n.floatValue());
        }
        if (n instanceof Integer) {
            return BigDecimal.valueOf(n.intValue());
        }
        if (n instanceof Long) {
            return BigDecimal.valueOf(n.longValue());
        }
        if (n instanceof BigInteger) {
            return new BigDecimal((BigInteger)n);
        }
        String s = D.s(n);
        return s == null ? null : new BigDecimal(s);
    }

    private static BigDecimal parseNumberString(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(69) > 0 || s.indexOf(101) > 0) {
            return BigDecimal.valueOf(Double.parseDouble(s));
        }
        return new BigDecimal(s);
    }
}

