/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.number;

import java.text.DecimalFormat;
import javax.script.ScriptContext;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.misc.StringUtil;
import kd.ai.gai.flow.untrans.IscAppUntrans;

public class ToCapital
implements NativeFunction {
    private static final String NAME = "capital";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public final Object call(ScriptContext ctx, Object[] args) {
        if (args.length == 1) {
            Object v = args[0];
            return ToCapital.toString(v);
        }
        throw new IllegalArgumentException("args.length is " + args.length);
    }

    public static String toString(Object v) {
        String[] n;
        if (v == null) {
            return "";
        }
        DecimalFormat fm = new DecimalFormat("0.00");
        String ss = fm.format(v);
        StringBuilder capital = new StringBuilder();
        if (ss.startsWith("-")) {
            n = ss.substring(1).split("\\.");
            capital.append("(\u8d1f)");
        } else {
            n = ss.split("\\.");
        }
        String s = n[0];
        if (s.length() <= 4) {
            ToCapital.append_4(s, capital);
        } else if (s.length() <= 8) {
            ToCapital.append_8(s, capital);
        } else if (s.length() <= 16) {
            ToCapital.append_16(s, capital);
        } else {
            return "{\u592a\u5927}";
        }
        capital.append('\u5143');
        ToCapital.append_2(n[1], capital);
        return capital.toString();
    }

    private static boolean append_16(String n, StringBuilder capital) {
        if ("0000000000000000".equals(n)) {
            return false;
        }
        int i = n.length() - 8;
        String high = n.substring(0, i);
        String low = n.substring(i);
        boolean exists = high.length() > 4 ? ToCapital.append_8(high, capital) : ToCapital.append_4(high, capital);
        if (exists) {
            capital.append('\u4ebf');
        } else {
            capital.append('\u96f6');
        }
        ToCapital.append_8(low, capital);
        return true;
    }

    private static boolean append_8(String n, StringBuilder capital) {
        if ("00000000".equals(n)) {
            return false;
        }
        int i = n.length() - 4;
        String high = n.substring(0, i);
        String low = n.substring(i);
        if (ToCapital.append_4(high, capital)) {
            capital.append('\u4e07');
        } else {
            capital.append('\u96f6');
        }
        ToCapital.append_4(low, capital);
        return true;
    }

    private static boolean append_4(String n, StringBuilder capital) {
        if ("0000".equals(n)) {
            return false;
        }
        char[] d = n.toCharArray();
        int offset = IscAppUntrans.rank.length - d.length;
        for (int i = 0; i < d.length; ++i) {
            int c = d[i] - 48;
            if (c == 0) {
                if (StringUtil.endsWith(capital, '\u96f6')) continue;
                capital.append('\u96f6');
                continue;
            }
            capital.append(IscAppUntrans.digital[c]);
            capital.append(IscAppUntrans.rank[i + offset]);
        }
        if (StringUtil.endsWith(capital, '\u96f6') && capital.length() > 1) {
            capital.delete(capital.length() - 1, capital.length());
        }
        return true;
    }

    private static void append_2(String n, StringBuilder capital) {
        if ("00".equals(n)) {
            capital.append('\u6574');
            return;
        }
        char[] d = n.toCharArray();
        for (int i = 0; i < d.length; ++i) {
            int c = d[i] - 48;
            if (c == 0) {
                if (StringUtil.endsWith(capital, '\u96f6')) continue;
                capital.append('\u96f6');
                continue;
            }
            capital.append(IscAppUntrans.digital[c]);
            capital.append(IscAppUntrans.rank2[i]);
        }
        if (StringUtil.endsWith(capital, '\u96f6')) {
            capital.append('\u5206');
        }
    }
}

