/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.string;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.script.ScriptContext;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.feature.tool.string.XmlObject;
import kd.ai.gai.flow.script.misc.StringUtil;
import kd.ai.gai.flow.script.misc.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Json2XmlWithAttribute
implements NativeFunction {
    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object obj = args[0];
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (map.size() == 1) {
                return this.createXml(map);
            }
            throw new IscBizException(ResManager.loadKDString("\u56e0\u751f\u6210\u7684Xml\u5fc5\u987b\u6709\u4e00\u4e2a\u6839\u8282\u70b9\uff0cJson2XmlWithAttribute\u51fd\u6570\u4f20\u5165\u7684Map\u683c\u5f0f\u53c2\u6570\u5fc5\u987b\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u952e\u503c\u5bf9", "Json2XmlWithAttribute_0", "isc-iscb-util", new Object[0]));
        }
        throw new IscBizException(String.format(ResManager.loadKDString("Json2XmlWithAttribute\u51fd\u6570\u5165\u53c2\u4ec5\u652f\u6301Map\u683c\u5f0f\uff0c\u5f53\u524d\u4f20\u5165\u7684\u6570\u636e\u7c7b\u578b\uff1a%1$s\uff0c\u6570\u636e\uff1a%2$s", "Json2XmlWithAttribute_3", "isc-iscb-util", new Object[0]), obj.getClass(), obj));
    }

    private Object createXml(Map<String, Object> map) {
        Map.Entry<String, Object> entry = map.entrySet().iterator().next();
        String rootName = entry.getKey();
        Object value = entry.getValue();
        Document doc = Xml.newDocument();
        Element root = doc.createElement(rootName);
        doc.appendChild(root);
        this.assignChild(root, value);
        return new XmlObject(root);
    }

    private void assignChild(Element param, Object value) {
        if (value instanceof Map) {
            for (Map.Entry<String, Object> entry : ((Map)value).entrySet()) {
                this.appendParam(param, entry);
            }
        } else {
            param.setTextContent(D.s(value));
        }
    }

    private void appendParam(Element op, Map.Entry<String, Object> e) {
        Object value = e.getValue();
        if (value == null) {
            return;
        }
        String name = e.getKey();
        if (name.startsWith("-")) {
            this.addAttribute(op, name.substring(1), value);
        } else if ("#text".equals(name)) {
            op.setTextContent(D.s(value));
        } else {
            this.addNode(op, name, value);
        }
    }

    private void addAttribute(Element op, String name, Object value) {
        if (value instanceof Collection) {
            op.setAttribute(name, StringUtil.join((Collection)value, ","));
        } else if (value.getClass().isArray()) {
            op.setAttribute(name, this.handleArray(value));
        } else {
            op.setAttribute(name, D.s(value));
        }
    }

    private String handleArray(Object value) {
        int length = Array.getLength(value);
        StringBuilder sb = new StringBuilder(length * 8);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(value, i);
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(item);
        }
        return sb.toString();
    }

    private void addNode(Element op, String name, Object value) {
        if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                this.appendNode(op, name, item);
            }
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value, i);
                this.appendNode(op, name, item);
            }
        } else {
            this.appendNode(op, name, value);
        }
    }

    private void appendNode(Element op, String name, Object value) {
        Element param = op.getOwnerDocument().createElement(name);
        op.appendChild(param);
        this.assignChild(param, value);
    }

    @Override
    public String name() {
        return "Json2XmlWithAttribute";
    }
}

