/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.string;

import java.util.ArrayList;
import java.util.Collection;
import javax.script.ScriptContext;
import kd.ai.gai.flow.script.core.NativeFunction;

public class RTrim
implements NativeFunction {
    @Override
    public String name() {
        return "rtrim";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object value = args[0];
        String[] suffixes = new String[args.length - 1];
        System.arraycopy(args, 1, suffixes, 0, args.length - 1);
        return RTrim.rtrim(value, suffixes);
    }

    public static Object rtrim(Object value, String[] suffixes) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            String s = value.toString();
            for (String suffix : suffixes) {
                if (!s.endsWith(suffix)) continue;
                s = s.substring(0, s.length() - suffix.length());
            }
            return s;
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            Object[] list = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                list[i] = RTrim.rtrim(values[i], suffixes);
            }
            return list;
        }
        if (value instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object e : (Collection)value) {
                list.add(RTrim.rtrim(e, suffixes));
            }
            return list;
        }
        throw new UnsupportedOperationException(value.toString());
    }
}

