/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.string;

import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Date;
import javax.script.ScriptContext;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.misc.Json;
import kd.ai.gai.flow.script.core.AbstractToolKit;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.feature.tool.string.FormatJson;
import kd.ai.gai.flow.script.feature.tool.string.FromBinary16;
import kd.ai.gai.flow.script.feature.tool.string.GetBytes;
import kd.ai.gai.flow.script.feature.tool.string.GetBytes2;
import kd.ai.gai.flow.script.feature.tool.string.HTMLEncode;
import kd.ai.gai.flow.script.feature.tool.string.HourMinute;
import kd.ai.gai.flow.script.feature.tool.string.HourMinute2;
import kd.ai.gai.flow.script.feature.tool.string.IndexOf;
import kd.ai.gai.flow.script.feature.tool.string.IsQname;
import kd.ai.gai.flow.script.feature.tool.string.Join;
import kd.ai.gai.flow.script.feature.tool.string.Json2Xml;
import kd.ai.gai.flow.script.feature.tool.string.Json2XmlWithAttribute;
import kd.ai.gai.flow.script.feature.tool.string.LastIndexOf;
import kd.ai.gai.flow.script.feature.tool.string.Left;
import kd.ai.gai.flow.script.feature.tool.string.Lpad;
import kd.ai.gai.flow.script.feature.tool.string.ParseJson;
import kd.ai.gai.flow.script.feature.tool.string.PrettyXml;
import kd.ai.gai.flow.script.feature.tool.string.PseudoBase64Decode;
import kd.ai.gai.flow.script.feature.tool.string.PseudoBase64Encode;
import kd.ai.gai.flow.script.feature.tool.string.RTrim;
import kd.ai.gai.flow.script.feature.tool.string.Replace;
import kd.ai.gai.flow.script.feature.tool.string.Right;
import kd.ai.gai.flow.script.feature.tool.string.Rpad;
import kd.ai.gai.flow.script.feature.tool.string.Space;
import kd.ai.gai.flow.script.feature.tool.string.Split;
import kd.ai.gai.flow.script.feature.tool.string.StringComparator;
import kd.ai.gai.flow.script.feature.tool.string.Substring;
import kd.ai.gai.flow.script.feature.tool.string.ToBinary;
import kd.ai.gai.flow.script.feature.tool.string.ToBinary16;
import kd.ai.gai.flow.script.feature.tool.string.ToCapital;
import kd.ai.gai.flow.script.feature.tool.string.ToLowerCase;
import kd.ai.gai.flow.script.feature.tool.string.ToString;
import kd.ai.gai.flow.script.feature.tool.string.ToUpperCase;
import kd.ai.gai.flow.script.feature.tool.string.Trim;
import kd.ai.gai.flow.script.feature.tool.string.URLDecode;
import kd.ai.gai.flow.script.feature.tool.string.URLEncode;
import kd.ai.gai.flow.script.feature.tool.string.ValueOf;
import kd.ai.gai.flow.script.feature.tool.string.Xml2Json;
import kd.ai.gai.flow.script.feature.tool.string.Xml2JsonWithAttribute;
import kd.ai.gai.flow.script.feature.tool.string.XmlDocCreator;
import kd.ai.gai.flow.script.feature.tool.string.XmlDocParser;

public class StringToolKit
extends AbstractToolKit
implements NativeFunction {
    public static final Comparator<String> COMPARATOR = new StringComparator();

    public StringToolKit() {
        this.register(new IndexOf());
        this.register(new LastIndexOf());
        this.register(new Split());
        this.register(new Join());
        this.register(new Trim());
        this.register(new Substring());
        this.register(new ValueOf());
        this.register(new ToString());
        this.register(new GetBytes());
        this.register(new GetBytes2());
        this.register(new ToBinary());
        this.register(new ToLowerCase());
        this.register(new ToUpperCase());
        this.register(new IsQname());
        this.register(new Left());
        this.register(new Right());
        this.register(new HourMinute());
        this.register(new HourMinute2());
        this.register(new URLEncode());
        this.register(new URLDecode());
        this.register(new HTMLEncode());
        this.register(new Space());
        this.register(new Replace());
        this.register(new Lpad());
        this.register(new Rpad());
        this.register(new RTrim());
        this.register(new ToCapital());
        this.register(new ToBinary16());
        this.register(new FromBinary16());
        this.register(new XmlDocCreator());
        this.register(new XmlDocParser());
        this.register(new FormatJson());
        this.register(new ParseJson());
        this.register(new Xml2Json());
        this.register(new Json2Xml());
        this.register(new PrettyXml());
        this.register(new PseudoBase64Decode());
        this.register(new PseudoBase64Encode());
        this.register(new Json2XmlWithAttribute());
        this.register(new Xml2JsonWithAttribute());
    }

    @Override
    public boolean isFor(Object object) {
        return object instanceof String || object instanceof StringBuilder || object instanceof StringBuffer;
    }

    @Override
    public String call(ScriptContext ctx, Object[] args) {
        Object v = args[0];
        if (v == null) {
            return "";
        }
        if (v instanceof byte[]) {
            String charset = args.length == 2 ? (String)args[1] : "UTF-8";
            try {
                return new String((byte[])v, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw CommonError.INVALID_CHARSET.create(e, charset);
            }
        }
        if (Json.isDateTime(v)) {
            return Json.DATE_TIME_FORMAT.get().format((Date)v);
        }
        return v.toString();
    }
}

