/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.feature.tool.string;

import javax.script.ScriptContext;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.data.BinaryString;
import kd.ai.gai.flow.script.encoding.Encoding;
import kd.ai.gai.flow.script.encoding.Hex;
import kd.ai.gai.flow.script.misc.UuidUtil;

public class ToBinary16
implements NativeFunction {
    @Override
    public String name() {
        return "toBinary16";
    }

    @Override
    public final Object call(ScriptContext ctx, Object[] args) {
        if (args.length == 1) {
            return ToBinary16.cast(args[0]);
        }
        throw new IllegalArgumentException("args.length is " + args.length);
    }

    public static BinaryString cast(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof BinaryString) {
            return (BinaryString)v;
        }
        String s = v.toString();
        if (UuidUtil.isUuid(s)) {
            return new BinaryString(UuidUtil.toBytes(UuidUtil.toUUID(s)));
        }
        if (s.length() == 32 && Hex.isHexString(s)) {
            return new BinaryString(Encoding.HEX.decode(s.getBytes(D.UTF_8)));
        }
        byte[] bytes = Encoding.stringToUtf8(s);
        if (bytes.length < 16) {
            byte[] tmp = new byte[16];
            System.arraycopy(bytes, 0, tmp, 0, bytes.length);
            for (int i = bytes.length; i < tmp.length; ++i) {
                tmp[i] = (byte)bytes.length;
            }
            return new BinaryString(tmp);
        }
        throw new IllegalArgumentException("'" + s + "' is an invalid binary16 string.");
    }
}

