/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.misc;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.script.ScriptContext;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.data.BinaryString;

public class AES_ECB_PKCS5_Decrypt
implements NativeFunction {
    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        if (args.length == 2) {
            try {
                return this.decrypt(args);
            }
            catch (Exception e) {
                throw CommonError.DECRYPTION_FAILURE.wrap(e);
            }
        }
        throw new IllegalArgumentException("function AES_ECB_PKCS5_Decrypt args.length is " + args.length);
    }

    private Object decrypt(Object[] args) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String key = (String)args[0];
        Object chiperText = args[1];
        if (key == null || chiperText == null) {
            throw new IllegalArgumentException("Both two parameters of function AES_ECB_PKCS5_Decrypt can not be null!");
        }
        byte[] raw = key.getBytes(D.UTF_8);
        SecretKeySpec spec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, spec);
        byte[] bytes = chiperText instanceof BinaryString ? ((BinaryString)chiperText).getBytes() : (byte[])chiperText;
        return cipher.doFinal(bytes);
    }

    @Override
    public String name() {
        return "AES_ECB_PKCS5_Decrypt";
    }
}

