/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.misc;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.script.ScriptContext;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.misc.NetUtil;
import kd.ai.gai.flow.misc.StringUtil;
import kd.ai.gai.flow.script.core.NativeFunction;

public class ClassInfo
implements NativeFunction {
    @Override
    public String name() {
        return "ClassInfo";
    }

    @Override
    public Map<String, Object> call(ScriptContext ctx, Object[] args) {
        String resourceName = this.getResourceName(args);
        String url = D.s(ClassInfo.class.getClassLoader().getResource(resourceName));
        if (url == null) {
            return this.defaultInfo(url);
        }
        return this.returnClassFileInfo(url);
    }

    private Map<String, Object> returnClassFileInfo(String url) {
        int j = url.indexOf(".jar!/");
        if (j < 0) {
            return this.defaultInfo(url);
        }
        return this.returnJarClassFileInfo(url, j);
    }

    private Map<String, Object> returnJarClassFileInfo(String url, int index) {
        try {
            return this.getZipClassFileInfoWithoutCatchError(url, index);
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getZipClassFileInfoWithoutCatchError(String url, int index) throws IOException {
        try (ZipFile zipFile = ClassInfo.getZipFile(url, index);){
            Map<String, Object> map = this.getZipClassFileInfo(zipFile, url, index);
            return map;
        }
    }

    private Map<String, Object> getZipClassFileInfo(ZipFile zipFile, String url, int index) {
        String resourceName = url.substring(index + ".jar!/".length());
        ZipEntry entry = zipFile.getEntry(resourceName);
        if (entry == null) {
            return this.defaultInfo(url);
        }
        return this.getZipClassInfo(url, entry, zipFile);
    }

    private Map<String, Object> getZipClassInfo(String url, ZipEntry entry, ZipFile zipFile) {
        Map<String, Object> info = this.defaultInfo(url);
        info.put("size", entry.getSize());
        info.put("crc", Long.toHexString(entry.getCrc()).toUpperCase());
        info.put("time", D.t(entry.getTime()));
        info.put("server", StringUtil.trim(NetUtil.getServerId(), 75));
        if (url.endsWith(".properties") && !url.endsWith("/poa.properties")) {
            try {
                info.put("content", NetUtil.readText(zipFile.getInputStream(entry)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return info;
    }

    private static ZipFile getZipFile(String url, int index) throws IOException {
        int i = url.indexOf(":/") + ":/".length();
        String path = url.substring(i, index) + ".jar";
        if (path.charAt(1) != ':') {
            path = "/" + path;
        }
        ZipFile zipFile = new ZipFile(new File(path));
        return zipFile;
    }

    public static ZipFile getZipFile(String url) throws IOException {
        int index = url.indexOf(".jar!/");
        if (index < 0) {
            return null;
        }
        return ClassInfo.getZipFile(url, index);
    }

    private Map<String, Object> defaultInfo(String url) {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>(4);
        info.put("url", url);
        return info;
    }

    private String getResourceName(Object[] args) {
        String className;
        String string = className = args.length > 0 ? D.s(args[0]) : ClassInfo.class.getName();
        if (className.indexOf(47) > 0) {
            return className;
        }
        return className.replace('.', '/') + ".class";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

