/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.script.ScriptContext;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.data.ArrayIterator;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.err.CommonError;
import kd.ai.gai.flow.misc.Base64;
import kd.ai.gai.flow.script.core.NativeFunction;
import kd.ai.gai.flow.script.encoding.Encoding;

public class JwkToRSAPrivateKey
implements NativeFunction {
    private static final int CODE_81 = 129;
    private static final int CODE_82 = 130;
    private static final int CODE_02 = 2;
    private static final int CODE_01 = 1;
    private static final int CODE_00 = 0;
    private static final int CODE_30 = 48;
    private static final int CODE_80 = 128;
    private static final int CODE_100 = 256;

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        if (!(args[0] instanceof Map)) {
            throw new IllegalArgumentException(ResManager.loadKDString("\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u65b9\u6cd5\u9700\u8981\u4f20\u5165map", "JwkToRSAPrivateKey_0", "isc-iscb-util", new Object[0]));
        }
        Map map = (Map)args[0];
        if (!"rsa".equalsIgnoreCase((String)map.get("kty"))) {
            throw new IllegalArgumentException(ResManager.loadKDString("\u4e0d\u652f\u6301\u7684kty\u7c7b\u578b", "JwkToRSAPrivateKey_1", "isc-iscb-util", new Object[0]));
        }
        try {
            return JwkToRSAPrivateKey.jwkToRSAPrivateKey(new Params(map));
        }
        catch (IOException e) {
            throw CommonError.SCRIPT_RUNTIME_ERROR.wrap(e);
        }
    }

    private static String jwkToRSAPrivateKey(Params params) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            os.write(48);
            int highNumber = params.getKeyLength() / 256;
            int lowNumber = params.getKeyLength() - highNumber * 256;
            JwkToRSAPrivateKey.writeLengthByte(os, highNumber, lowNumber);
            os.write(2);
            os.write(1);
            os.write(0);
            Iterator<String> iterator = params.getKeys();
            while (iterator.hasNext()) {
                JwkToRSAPrivateKey.writeKey(os, params, iterator.next());
            }
            byte[] bytes = os.toByteArray();
            String string = "-----BEGIN RSA PRIVATE KEY-----" + new String(Encoding.BASE64.encode(bytes), D.UTF_8) + "-----END RSA PRIVATE KEY-----";
            return string;
        }
    }

    private static void writeKey(ByteArrayOutputStream os, Params params, String key) throws IOException {
        os.write(2);
        int highNumber = params.getLength(key) / 256;
        int lowNumber = params.getLength(key) - highNumber * 256;
        JwkToRSAPrivateKey.writeLengthByte(os, highNumber, lowNumber);
        if (params.isZeroPadding(key)) {
            os.write(0);
        }
        os.write(Encoding.BASE64.decode(params.getContent(key).getBytes(D.UTF_8)));
    }

    private static void writeLengthByte(ByteArrayOutputStream os, int highNumber, int lowNumber) {
        if (highNumber == 0) {
            if (lowNumber >= 128) {
                os.write(129);
            }
        } else {
            os.write(130);
            os.write(highNumber);
        }
        os.write(lowNumber);
    }

    @Override
    public String name() {
        return "JwkToRSAPrivateKey";
    }

    static class Params {
        private int keyLen = 3;
        private final String[] KEYS = new String[]{"n", "e", "d", "p", "q", "dp", "dq", "qi"};
        private final Map<String, Integer> lenMap;
        private final Map<String, Boolean> zeroMap;
        private final Map<String, String> map;

        public Params(Map<String, String> map) throws UnsupportedEncodingException {
            this.map = map;
            this.lenMap = new HashMap<String, Integer>();
            this.zeroMap = new HashMap<String, Boolean>();
            this.init();
        }

        private void init() throws UnsupportedEncodingException {
            for (String v : this.KEYS) {
                this.map.put(v, D.s(this.map.get(v).replaceAll("-", "+").replaceAll("_", "/")));
                this.count(v);
            }
        }

        private void count(String v) throws UnsupportedEncodingException {
            int length = Encoding.BASE64.decode(this.map.get(v).getBytes(D.UTF_8)).length;
            if (Base64.decode(this.map.get(v).getBytes(D.UTF_8))[0] > 0) {
                this.keyLen += length;
                this.lenMap.put(v, length);
                this.zeroMap.put(v, Boolean.FALSE);
            } else {
                this.keyLen += length + 1;
                this.lenMap.put(v, length + 1);
                this.zeroMap.put(v, Boolean.TRUE);
            }
            length = this.lenMap.get(v);
            this.keyLen = length / 256 != 0 ? (this.keyLen += 4) : (length >= 128 ? (this.keyLen += 3) : (this.keyLen += 2));
        }

        public int getKeyLength() {
            return this.keyLen;
        }

        public int getLength(String key) {
            return this.lenMap.get(key);
        }

        public boolean isZeroPadding(String key) {
            return this.zeroMap.get(key);
        }

        public String getContent(String key) {
            return this.map.get(key);
        }

        public Iterator<String> getKeys() {
            return new ArrayIterator<String>(this.KEYS);
        }
    }
}

