/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kd.ai.gai.dataentity.resource.ResManager;
import kd.ai.gai.flow.db.DbUtil;
import kd.ai.gai.flow.dt.D;
import kd.ai.gai.flow.script.misc.Consts;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class Xml {
    public static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    public static final String ACCESS_EXTERNAL_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
    public static final String ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";

    public static Document parse(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            try {
                factory.setFeature(DISALLOW_DOCTYPE_DECL, true);
            }
            catch (IllegalArgumentException e) {
                DbUtil.getLogger().error(ResManager.loadKDString("XML\u4e0d\u652f\u6301\u7279\u6027\uff1aDISALLOW_DOCTYPE_DECL", "Xml_0", "isc-iscb-util", new Object[0]), e);
            }
            try {
                factory.setAttribute(ACCESS_EXTERNAL_DTD, "");
            }
            catch (IllegalArgumentException e) {
                DbUtil.getLogger().error(ResManager.loadKDString("XML\u4e0d\u652f\u6301\u5c5e\u6027\uff1aACCESS_EXTERNAL_DTD", "Xml_1", "isc-iscb-util", new Object[0]), e);
            }
            try {
                factory.setAttribute(ACCESS_EXTERNAL_SCHEMA, "");
            }
            catch (IllegalArgumentException e) {
                DbUtil.getLogger().error(ResManager.loadKDString("XML\u4e0d\u652f\u6301\u5c5e\u6027\uff1aACCESS_EXTERNAL_SCHEMA", "Xml_2", "isc-iscb-util", new Object[0]), e);
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(Consts.UTF_8));
            return builder.parse(is);
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    public static Document newDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    public static String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String toString(Document document, boolean isPretty) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            try {
                tf.setAttribute(ACCESS_EXTERNAL_DTD, "");
            }
            catch (IllegalArgumentException e) {
                DbUtil.getLogger().error(ResManager.loadKDString("XML\u4e0d\u652f\u6301\u5c5e\u6027\uff1aACCESS_EXTERNAL_DTD", "Xml_1", "isc-iscb-util", new Object[0]), e);
            }
            try {
                tf.setAttribute(ACCESS_EXTERNAL_SCHEMA, "");
            }
            catch (IllegalArgumentException e) {
                DbUtil.getLogger().error(ResManager.loadKDString("XML\u4e0d\u652f\u6301\u5c5e\u6027\uff1aACCESS_EXTERNAL_SCHEMA", "Xml_2", "isc-iscb-util", new Object[0]), e);
            }
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", "UTF-8");
            if (isPretty) {
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("doctype-public", "yes");
                t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(document), new StreamResult(bos));
            return new String(bos.toByteArray(), Consts.UTF_8);
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    public static String toString(Document doc) {
        return Xml.toString(doc, false);
    }

    public static Element getChild(Element parent, String tagName) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            String name;
            if (!(nodes.item(i) instanceof Element) || !(name = (e = (Element)nodes.item(i)).getTagName()).endsWith(tagName)) continue;
            if (name.length() == tagName.length()) {
                return e;
            }
            int j = name.length() - tagName.length() - 1;
            if (j <= 0 || name.charAt(j) != ':') continue;
            return e;
        }
        return null;
    }

    public static Collection<Element> getChildren(Element parent, String tagName) {
        NodeList nodes = parent.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e;
            if (!(nodes.item(i) instanceof Element) || !(e = (Element)nodes.item(i)).getNodeName().equals(tagName)) continue;
            children.add(e);
        }
        return children;
    }

    public static Collection<Element> getChildren(Element parent) {
        NodeList nodes = parent.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!(nodes.item(i) instanceof Element)) continue;
            Element e = (Element)nodes.item(i);
            children.add(e);
        }
        return children;
    }
}

