/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.misc.aes;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.ai.gai.flow.script.data.BinaryString;

public class AESUtil {
    public static byte[] encrypt(String mode, String padding, byte[] key, byte[] data, byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
        if (key == null || data == null) {
            throw new IllegalArgumentException(" key or data can not be null!");
        }
        Cipher cipher = Cipher.getInstance("AES/" + mode + '/' + padding);
        if (iv != null) {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(1, AESUtil.toKey(key), ivSpec);
        } else {
            cipher.init(1, AESUtil.toKey(key));
        }
        return cipher.doFinal(data);
    }

    private static Key toKey(byte[] key) {
        return new SecretKeySpec(key, "AES");
    }

    public static byte[] getBytes(Object args) {
        byte[] bytes = args instanceof BinaryString ? ((BinaryString)args).getBytes() : (byte[])args;
        return bytes;
    }

    public static byte[] decrypt(String mode, String padding, byte[] key, byte[] data, byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (key == null || data == null) {
            throw new IllegalArgumentException(" key or data can not be null!");
        }
        Cipher cipher = Cipher.getInstance("AES/" + mode + '/' + padding);
        if (iv != null) {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(2, AESUtil.toKey(key), ivSpec);
        } else {
            cipher.init(2, AESUtil.toKey(key));
        }
        return cipher.doFinal(data);
    }
}

