/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.misc.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Timestamp;
import kd.ai.gai.flow.misc.StringUtil;
import kd.ai.gai.flow.script.misc.Const;
import kd.ai.gai.flow.script.misc.log.Logger;

public class DefaultLogger
implements Logger {
    public static final Const<PrintStream> OUT = new Const<PrintStream>(DefaultLogger.getPrintStream());

    @Override
    public void debug(String message) {
        this.log(Logger.Type.Debug, message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log(Logger.Type.Debug, message, t);
    }

    @Override
    public void error(String message) {
        this.log(Logger.Type.Error, message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log(Logger.Type.Error, message, t);
    }

    @Override
    public void info(String message) {
        this.log(Logger.Type.Info, message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log(Logger.Type.Info, message, t);
    }

    @Override
    public void warn(String message) {
        this.log(Logger.Type.Warn, message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log(Logger.Type.Warn, message, t);
    }

    @Override
    public void log(Logger.Type type, String message) {
        this.log(type, message, null);
    }

    @Override
    public void echo(String message) {
        this.log(Logger.Type.Echo, message, null);
    }

    @Override
    public void log(Logger.Type type, String message, Throwable error) {
        StringBuilder s = new StringBuilder();
        s.append(Thread.currentThread().getName()).append(':').append((Object)type).append(", ");
        s.append(new Timestamp(System.currentTimeMillis()));
        s.append("\r\n\t").append(message);
        if (error != null) {
            s.append("\r\n").append(StringUtil.toString(error));
        }
        OUT.get().println(s);
    }

    private static PrintStream getPrintStream() {
        PrintStream obj;
        try {
            Class<System> cls = System.class;
            obj = (PrintStream)cls.getField("out").get(null);
        }
        catch (Exception e) {
            obj = null;
        }
        if (obj == null) {
            obj = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            });
        }
        return obj;
    }
}

