/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import kd.ai.gai.flow.debugger.DebuggableResource;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.misc.mem.MemoryUtil;
import kd.ai.gai.flow.misc.mem.ObjectSizeIgnored;
import kd.ai.gai.flow.script.LifeScriptContext;
import kd.ai.gai.flow.script.Util;
import kd.ai.gai.flow.script.analyzer.expr.DualInvoker;
import kd.ai.gai.flow.script.core.Predicate;
import kd.ai.gai.flow.script.feature.control.advanced.Debuggable;
import kd.ai.gai.flow.script.misc.Consts;
import kd.ai.gai.flow.script.parser.ScriptParser;
import kd.ai.gai.flow.script.parser.ScriptReader;
import kd.ai.gai.flow.script.statement.Block;
import kd.ai.gai.flow.script.statement.Invocation;

public final class Program
extends CompiledScript
implements DebuggableResource,
ObjectSizeIgnored {
    private long timeout = Long.MAX_VALUE;
    private final ScriptEngine engine;
    private final Object impl;
    private final Map<String, Object> ctx;
    private final ScriptReader reader;

    public Program(ScriptEngine engine, ScriptReader reader, Object impl, Map<String, Object> ctx) {
        this.engine = engine;
        this.impl = impl;
        this.ctx = Collections.unmodifiableMap(ctx);
        this.reader = reader;
    }

    public ScriptReader getScriptReader() {
        return this.reader;
    }

    @Override
    public Object eval() throws ScriptException {
        LifeScriptContext context = new LifeScriptContext();
        return this.eval(context);
    }

    @Override
    public Object eval(Bindings bindings) throws ScriptException {
        LifeScriptContext context = new LifeScriptContext(bindings);
        return this.eval(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(ScriptContext context) {
        if (!(context instanceof LifeScriptContext)) {
            throw new IscBizException("ScriptContext " + context.getClass() + " doesn't extend LifeScriptContext!");
        }
        LifeScriptContext ctx = (LifeScriptContext)context;
        ctx.setProgram(this);
        try {
            Util.clearSignal(context);
            Object object = Util.eval(context, this.impl);
            return object;
        }
        finally {
            MemoryUtil.clearLast();
            ctx.unsetProgram(this);
        }
    }

    public Object getImpl() {
        return this.impl;
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return this.impl.toString();
    }

    public Map<String, Object> getContext() {
        return this.ctx;
    }

    public Object[] getElements() {
        Set elements = (Set)this.ctx.get(ScriptParser.FIELD_ELEMENTS);
        if (elements == null || elements.size() == 0) {
            return Consts.EMPTY_OBJ_ARRAY;
        }
        return elements.toArray();
    }

    public Object[] getConsts() {
        Set elements = (Set)this.ctx.get(ScriptParser.FIELD_ELEMENTS);
        if (elements == null || elements.size() == 0) {
            return Consts.EMPTY_OBJ_ARRAY;
        }
        ArrayList consts = new ArrayList(elements.size());
        for (Object el : elements) {
            if (el instanceof String) {
                consts.add(el);
                continue;
            }
            if (!(el instanceof Number)) continue;
            consts.add(el);
        }
        return consts.toArray();
    }

    public boolean isPredicate() {
        if (!(this.impl instanceof Block)) {
            return false;
        }
        Block b = (Block)this.impl;
        if (b.length() != 1) {
            return false;
        }
        return Program.isPredicate(b.get(0));
    }

    public static boolean isPredicate(Object i) {
        if (i instanceof Invocation) {
            return ((Invocation)i).get(0) instanceof Predicate;
        }
        if (i instanceof DualInvoker) {
            return ((DualInvoker)i).isPredicate();
        }
        return i instanceof Predicate;
    }

    @Override
    public Set<Integer> collectBreakpoints() {
        HashSet<Integer> breakpoints = new HashSet<Integer>(15);
        if (this.impl instanceof Debuggable) {
            ((Debuggable)this.impl).collectBreakpoints(breakpoints);
        }
        return breakpoints;
    }

    @Override
    public String getResourceId() {
        return this.reader.getResourceId();
    }

    @Override
    public boolean attachBreakpoint(int line) {
        if (this.impl instanceof Debuggable) {
            return ((Debuggable)this.impl).attachBreakpoint(line);
        }
        return false;
    }

    @Override
    public void detachBreakpoint(int line) {
        if (this.impl instanceof Debuggable) {
            ((Debuggable)this.impl).detachBreakpoint(line);
        }
    }

    @Override
    public String getLine(int line) {
        return this.reader.getLine(line);
    }

    @Override
    public int getLineCount() {
        return this.reader.lineCount();
    }
}

