/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.misc.mem.ObjectSizeIgnored;
import kd.ai.gai.flow.script.util.Symbol;

public final class ScriptReader
implements ObjectSizeIgnored {
    private final String id = UUID.randomUUID().toString();
    private final String res;
    private List<String> lines = new ArrayList<String>();
    private StringBuilder current = new StringBuilder();
    private Reader r;
    private int last;
    private boolean useLast;
    private int line = 1;
    private int col = 0;

    public ScriptReader(Reader r, String res) {
        this.res = res;
        this.r = r;
        this.last = -2;
        this.useLast = true;
    }

    public String getResourceId() {
        return this.res;
    }

    public String getId() {
        return this.id;
    }

    private void innerRead() {
        try {
            int c = this.r.read();
            if (c == 13 || c == 10) {
                if (this.last != 13 || c != 10) {
                    this.appendCurrentLine();
                }
            } else if (c < 0) {
                this.appendCurrentLine();
            } else {
                ++this.col;
                this.current.append((char)c);
            }
            this.last = c;
        }
        catch (IOException e) {
            throw new IscBizException(e);
        }
    }

    private void appendCurrentLine() {
        ++this.line;
        this.col = 0;
        this.lines.add(this.current.toString());
        this.current = new StringBuilder();
    }

    public int read() {
        if (!this.useLast) {
            this.innerRead();
        }
        this.useLast = false;
        return this.last;
    }

    public void backspace() {
        if (this.useLast) {
            throw new UnsupportedOperationException();
        }
        this.useLast = true;
    }

    public boolean isEOF() {
        return this.last < 0;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.col;
    }

    public String getLine(int line) {
        int k = Math.min(Math.max(line, 1), this.lines.size());
        return this.lines.get(k - 1);
    }

    public List<String> getLines() {
        return new ArrayList<String>(this.lines);
    }

    public int lineCount() {
        return this.lines.size();
    }

    public void skipWhiteSpace() {
        int c = Symbol.skipWhiteSpace(this);
        this.backspace();
    }
}

