/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.statement;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.ai.gai.flow.except.IscBizException;
import kd.ai.gai.flow.script.LifeScriptEngine;
import kd.ai.gai.flow.script.core.Analyzer;
import kd.ai.gai.flow.script.core.Identifier;
import kd.ai.gai.flow.script.core.Reference;
import kd.ai.gai.flow.script.core.Statement;
import kd.ai.gai.flow.script.core.StopAnalyzeElements;
import kd.ai.gai.flow.script.feature.control.advanced.DebugTrap;
import kd.ai.gai.flow.script.feature.control.advanced.Debuggable;

public abstract class AbstractStatement
implements Debuggable,
Statement {
    private int _line = -1;
    private int _column = -1;
    protected final Object[] elements;
    protected LifeScriptEngine engine;
    protected Map<String, Object> ctx;
    private Identifier _terminator;
    private boolean _isBlock;
    private final DebugTrap trap;

    protected AbstractStatement(LifeScriptEngine engine, Map<String, Object> ctx, int line, int column, Identifier terminator, List<Object> elements, boolean isBlock) {
        this.engine = engine;
        this.ctx = ctx;
        this.elements = elements.toArray();
        this.trap = new DebugTrap(null, line);
        this._line = line;
        this._column = column;
        this._terminator = terminator;
        this._isBlock = isBlock;
    }

    protected AbstractStatement(LifeScriptEngine engine, Map<String, Object> ctx, Object[] elements, int line) {
        this.trap = new DebugTrap(null, line);
        this.engine = engine;
        this.ctx = ctx;
        this.elements = elements;
        this._line = line;
    }

    @Override
    public final int line() {
        return this._line;
    }

    @Override
    public final int column() {
        return this._column;
    }

    @Override
    public boolean isBlock() {
        return this._isBlock;
    }

    @Override
    public final Object get(int i) {
        return this.elements[i];
    }

    @Override
    public final int length() {
        return this.elements.length;
    }

    @Override
    public final Identifier terminator() {
        return this._terminator;
    }

    @Override
    public void terminator(Identifier terminator) {
        this._terminator = terminator;
    }

    @Override
    public final Statement reconstruct(Object[] analyzed) {
        AbstractStatement cloned = this.clone(analyzed);
        cloned._terminator = this._terminator;
        return cloned;
    }

    protected abstract AbstractStatement clone(Object[] var1);

    public String toString() {
        if (this.elements.length == 1) {
            return AbstractStatement.toString(this.elements[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Object e : this.elements) {
            sb.append(' ');
            sb.append(AbstractStatement.toString(e));
        }
        sb.append(" )");
        return sb.toString();
    }

    protected static String toString(Object el) {
        Class<?> c;
        if (el == null) {
            return "null";
        }
        String s = el.toString();
        if (s.startsWith((c = el.getClass()).getName())) {
            if (el instanceof Identifier) {
                s = ((Identifier)el).name();
                if (s == null) {
                    s = c.getSimpleName();
                }
            } else {
                s = c.getSimpleName();
            }
        }
        return s;
    }

    @Override
    public LifeScriptEngine getEngine() {
        return this.engine;
    }

    @Override
    public Map<String, Object> getContext() {
        return this.ctx;
    }

    @Override
    public final Object analyze() throws ScriptException {
        this.analyzeElements();
        return this.analyzeSelf();
    }

    protected final Object analyzeSelf() throws ScriptException {
        Statement s = this;
        for (int i = 0; i < this.engine.getAnalyzerCount(); ++i) {
            Analyzer a = this.engine.getAnalyzer(i);
            Object analyzed = a.analyze(s);
            if (analyzed == null) {
                throw new IscBizException("Analyzer '" + a + "' returned a null.");
            }
            if (!(analyzed instanceof Statement)) {
                return analyzed;
            }
            s = (Statement)analyzed;
        }
        return s;
    }

    protected void analyzeElements() throws ScriptException {
        if (this.elements.length == 0) {
            return;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Object a;
            Object el = this.elements[i];
            if (el instanceof StopAnalyzeElements) {
                return;
            }
            if (el instanceof Statement) {
                this.elements[i] = ((Statement)el).analyze();
                continue;
            }
            if (!(el instanceof Reference) || (a = this.ctx.get(((Reference)el).name())) == null) continue;
            this.elements[i] = a;
        }
    }

    @Override
    public Object[] getElements() {
        return this.elements;
    }

    protected final void checkBreakpoint(ScriptContext ctx) {
        this.trap.get(ctx);
    }

    @Override
    public final boolean attachBreakpoint(int line) {
        if (this.trap.attachBreakpoint(line)) {
            return true;
        }
        for (Object e : this.elements) {
            if (!(e instanceof Debuggable) || !((Debuggable)e).attachBreakpoint(line)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void collectBreakpoints(Set<Integer> breakpoints) {
        this.trap.collectBreakpoints(breakpoints);
        for (Object e : this.elements) {
            if (!(e instanceof Debuggable)) continue;
            ((Debuggable)e).collectBreakpoints(breakpoints);
        }
    }

    @Override
    public final void detachBreakpoint(int line) {
        this.trap.detachBreakpoint(line);
        for (Object e : this.elements) {
            if (!(e instanceof Debuggable)) continue;
            ((Debuggable)e).detachBreakpoint(line);
        }
    }
}

