/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.script.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class Numeric {
    public static final int VARIANT = 0;
    public static final int DECIMAL = 1;
    public static final int DOUBLE = 2;
    public static final int FLOAT = 3;
    public static final int BIGINT = 4;
    public static final int LONG = 5;
    public static final int INT = 6;
    public static final int SHORT = 7;
    public static final int BYTE = 8;

    public static Number parse(String s) {
        Number value = s.endsWith("L") || s.endsWith("l") ? (Number)Long.parseLong(s.substring(0, s.length() - 1)) : (Number)(s.endsWith("N") || s.endsWith("n") ? new BigDecimal(s.substring(0, s.length() - 1)) : (s.contains("E") || s.contains("e") ? (Number)Double.parseDouble(s) : (Number)(s.endsWith("V") || s.endsWith("v") ? new BigInteger(s.substring(0, s.length() - 1)) : (s.endsWith("F") || s.endsWith("f") || s.endsWith("D") || s.endsWith("d") ? (Number)Double.parseDouble(s.substring(0, s.length() - 1)) : (Number)(s.indexOf(46) >= 0 ? new BigDecimal(s) : (s.length() < 10 ? (Number)Integer.parseInt(s) : (Number)(s.length() < 20 ? Long.valueOf(Long.parseLong(s)) : new BigInteger(s))))))));
        return value;
    }

    public static int normalize(Object[] values) {
        int min = 6;
        int max = 0;
        for (Object v : values) {
            int type = Numeric.getType(v);
            if (type < min) {
                min = type;
            }
            if (type <= max) continue;
            max = type;
        }
        if (min == max && min <= 6 && min != 3 && min != 0) {
            return min;
        }
        switch (min) {
            case 6: 
            case 7: 
            case 8: {
                Numeric.toInteger(values);
                return 6;
            }
            case 5: {
                Numeric.toLong(values);
                return 5;
            }
            case 1: {
                Numeric.toDecimal(values);
                return 1;
            }
            case 4: {
                Numeric.toBigInteger(values);
                return 4;
            }
            case 2: 
            case 3: {
                Numeric.toDouble(values);
                return 2;
            }
            case 0: {
                Numeric.toString(values);
                return 0;
            }
        }
        throw new UnsupportedOperationException("unexpected type {" + min + "}.");
    }

    private static void toString(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (!(v instanceof StringBuilder) && !(v instanceof StringBuffer)) continue;
            values[i] = v.toString();
        }
    }

    private static void toDouble(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (v instanceof Double) continue;
            values[i] = ((Number)v).doubleValue();
        }
    }

    private static void toInteger(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (v instanceof Integer) continue;
            values[i] = ((Number)v).intValue();
        }
    }

    private static void toBigInteger(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (v instanceof BigInteger) continue;
            values[i] = new BigInteger(v.toString());
        }
    }

    private static void toDecimal(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (v instanceof BigDecimal) continue;
            try {
                values[i] = new BigDecimal(v.toString());
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("'" + v + "' is invalid number format!", e);
            }
        }
    }

    private static void toLong(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (v instanceof Long) continue;
            values[i] = ((Number)v).longValue();
        }
    }

    public static int getType(Object v) {
        if (v instanceof Integer) {
            return 6;
        }
        if (v instanceof Long) {
            return 5;
        }
        if (v instanceof BigDecimal) {
            return 1;
        }
        if (v instanceof Double) {
            return 2;
        }
        if (v instanceof Float) {
            return 3;
        }
        if (v instanceof BigInteger) {
            return 4;
        }
        if (v instanceof Byte) {
            return 8;
        }
        if (v instanceof Short) {
            return 7;
        }
        return 0;
    }

    public static Number negate(Number value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return -((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return -((Long)value).longValue();
        }
        if (value instanceof Double) {
            return -((Double)value).doubleValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).negate();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).negate();
        }
        if (value instanceof Short) {
            return (int)(-((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return (int)(-((Byte)value).byteValue());
        }
        if (value instanceof Float) {
            return Float.valueOf(-((Float)value).floatValue());
        }
        throw new UnsupportedOperationException("-" + value.getClass().getName());
    }

    public static boolean isNumberFlag(int c) {
        return c == 70 || c == 76 || c == 78 || c == 86 || c == 69 || c == 68 || c == 102 || c == 108 || c == 110 || c == 118 || c == 101 || c == 100 || c == 120;
    }
}

