/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.flow.test;

import java.util.Map;
import kd.ai.gai.flow.dt.DataTypes;
import kd.ai.gai.flow.flow.core.FC;
import kd.ai.gai.flow.flow.core.Flow;
import kd.ai.gai.flow.flow.core.FlowBuilder;
import kd.ai.gai.flow.flow.core.FlowRuntime;
import kd.ai.gai.flow.flow.core.NodeBuilder;
import kd.ai.gai.flow.flow.core.Profile;
import kd.ai.gai.flow.flow.core.Transition;
import kd.ai.gai.flow.flow.core.plugin.Application;
import kd.ai.gai.flow.flow.core.plugin.Callback;
import kd.ai.gai.flow.flow.core.plugin.Condition;
import kd.ai.gai.flow.test.SynchronizerDemo;

public class SimpleFlowTest {
    public static void main(String[] args) throws Exception {
        SimpleFlowTest test = new SimpleFlowTest();
        test.test0();
    }

    public void test0() throws Exception {
        FlowBuilder builder = FC.getFactory().newInstance("test", "test");
        builder.variable("v", "V", "V", DataTypes.STRING);
        builder.setSynchronizer(SynchronizerDemo.INS);
        NodeBuilder node = builder.node("a", "A");
        node.biz(Application.NOP, Callback.NOP);
        node.setSynchronizer(SynchronizerDemo.INS);
        node.node("sub", "sub");
        node = builder.node("b", "B");
        node.setSynchronizer(SynchronizerDemo.INS);
        node = builder.node("c", "C");
        node.setSynchronizer(SynchronizerDemo.INS);
        builder.transition("t1", "t", "a", "b", Transition.Type.NORMAL);
        builder.transition("t2", "t", "a", "c", Transition.Type.NORMAL).setCondition(Condition.TRUE);
        Flow flow = builder.end();
        System.out.println(flow.dumpMicroPrograms());
        FlowRuntime runtime = flow.newInstance();
        runtime.setProfile(Profile.DEBUG);
        runtime.execute(new Object[0]);
        String last = runtime.getLastExecution().getId();
        Map<String, Object> doc = runtime.toJson();
        runtime = flow.fromJson(doc);
        runtime.signal(last);
    }
}

