/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.gpt.action;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.UUID;
import kd.ai.gai.core.agent.tool.util.HttpXmlUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DaasGwUtil {
    public static final String domain = "https://daasapi.kdcloud.com";

    public static JSONObject httpPost(String url, JSONObject headers, JSONObject json) throws IOException {
        json = json == null ? new JSONObject() : json;
        HashMap header = new HashMap();
        if (headers != null && headers.size() > 0) {
            for (Map.Entry ent : headers.entrySet()) {
                header.put(ent.getKey(), ent.getValue().toString());
            }
        }
        String result = HttpXmlUtils.postApplicationJSON((String)url, header, (String)json.toJSONString());
        JSONObject response = JSONObject.parseObject((String)result);
        return response;
    }

    public static JSONObject getHeaders(String appId, String appSecret) {
        String nonce = UUID.randomUUID().toString().replaceAll("-", "");
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = DaasGwUtil.sign(appSecret, timestamp, nonce, null);
        JSONObject header = new JSONObject();
        header.put("x-acgw-timestamp", (Object)timestamp);
        header.put("x-acgw-nonce", (Object)nonce);
        header.put("x-acgw-sign", (Object)sign);
        header.put("x-acgw-appid", (Object)appId);
        return header;
    }

    private static String sign(String appSecret, String timestamp, String nonce, SortedMap<String, String> params) {
        StringBuilder sber = new StringBuilder();
        sber.append(timestamp).append(nonce);
        if (params != null && MapUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (StringUtils.isNotEmpty((CharSequence)v)) {
                    byte[] bytes = org.apache.commons.codec.binary.StringUtils.getBytesUtf8((String)v);
                    sber.append(new String(bytes, 0, Math.min(bytes.length, 100), StandardCharsets.UTF_8));
                }
            });
        }
        return Base64.encodeBase64String((byte[])new HmacUtils(HmacAlgorithms.HMAC_SHA_256, org.apache.commons.codec.binary.StringUtils.getBytesUtf8((String)appSecret)).hmac(org.apache.commons.codec.binary.StringUtils.getBytesUtf8((String)sber.toString())));
    }
}

