/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.gpt.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.gpt.action.DaasGwUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class DaasQueryAction
implements IGPTAction {
    private static final Log logger = LogFactory.getLog(DaasQueryAction.class);

    public Map<String, String> invokeAction(String action, Map<String, String> map) {
        map = map != null ? map : new HashMap();
        String appId = (String)map.get("gwAppId");
        String appName = (String)map.get("gwAppName");
        String appSecret = (String)map.get("gwAppSecret");
        map.remove("gwAppId");
        map.remove("gwAppName");
        map.remove("gwAppSecret");
        logger.info("action : {}, input: {}", (Object)action, (Object)JSONObject.toJSONString(map));
        logger.info("appId: " + appId + "  appName: " + appName);
        String domain = "";
        JSONObject apiMetaData = new JSONObject();
        try {
            String daasApis = DaasQueryAction.queryCommonParam("daasApisConfig");
            JSONObject config = JSON.parseObject((String)daasApis);
            domain = config.getString("domain");
            apiMetaData = config.getJSONObject("apiMetaData");
            apiMetaData = apiMetaData != null ? apiMetaData : new JSONObject();
        }
        catch (Exception e) {
            logger.error("DAAS API \u914d\u7f6e\u53c2\u6570\u8bfb\u53d6\u5f02\u5e38\uff01");
        }
        Map<String, String> rtn = new HashMap<String, String>();
        if (!(action == null || apiMetaData.getJSONObject(action) == null || StringUtils.isEmpty((String)domain) || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)appSecret) || StringUtils.isEmpty((String)appName))) {
            JSONObject routeItem = apiMetaData.getJSONObject(action);
            String apiRoute = routeItem.getString("apiRoute");
            String apiDesc = routeItem.getString("apiDesc");
            String requestMethod = routeItem.getString("requestMethod");
            String responseFormat = routeItem.getString("responseFormat");
            JSONArray params = routeItem.getJSONArray("params");
            JSONArray headers = routeItem.getJSONArray("headers");
            params = params != null ? params : new JSONArray();
            headers = headers != null ? headers : new JSONArray();
            JSONObject configHeaders = new JSONObject();
            for (int i = 0; i < headers.size(); ++i) {
                JSONObject configHeader = headers.getJSONObject(i);
                configHeaders.putAll((Map)configHeader);
            }
            String url = domain + apiRoute;
            JSONObject requestBody = new JSONObject();
            requestBody.putAll(map);
            for (int i = 0; i < params.size(); ++i) {
                JSONObject param = params.getJSONObject(i);
                String paramKey = param.getString("paramKey");
                String defaultValue = param.getString("defaultValue");
                if (requestBody.containsKey((Object)paramKey) || defaultValue == null) continue;
                requestBody.put(paramKey, (Object)defaultValue);
            }
            if ("POST".equals(requestMethod) && "JSON".equals(responseFormat)) {
                String clientCallName;
                String clientId = "client_id";
                String clientCompanyId = "client_company_id";
                String clientCompanyName = "client_company_name";
                requestBody.put(clientId, (Object)appId);
                requestBody.put(clientCompanyId, (Object)appId);
                requestBody.put(clientCompanyName, (Object)appName);
                String clientCallId = (String)map.get(clientCompanyId);
                if (!StringUtils.isEmpty((String)clientCallId)) {
                    requestBody.put(clientCompanyId, (Object)clientCallId);
                }
                if (!StringUtils.isEmpty((String)(clientCallName = (String)map.get(clientCompanyName)))) {
                    requestBody.put(clientCompanyName, (Object)clientCallName);
                }
                logger.info("apiInfo: " + apiDesc);
                logger.info("requestBody:{}", (Object)requestBody.toJSONString());
                JSONObject response = new JSONObject();
                try {
                    JSONObject signHeaders = DaasGwUtil.getHeaders(appId, appSecret);
                    JSONObject requestHeaders = new JSONObject();
                    requestHeaders.putAll((Map)configHeaders);
                    requestHeaders.putAll((Map)signHeaders);
                    response = DaasGwUtil.httpPost(url, requestHeaders, requestBody);
                    logger.info("response:{}", (Object)response);
                }
                catch (IOException e) {
                    logger.error("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25:{}", (Object)e.getMessage());
                    response.put("status", (Object)"fail");
                    response.put("message", (Object)"\u53d1\u9001\u8bf7\u6c42\u5931\u8d25");
                }
                rtn = (Map)response.toJavaObject(Map.class);
            }
        }
        logger.info("action : {}, output: {}", (Object)action, (Object)JSONObject.toJSONString(rtn));
        return rtn;
    }

    public static String queryCommonParam(String paramKey) {
        QFilter qFilter = new QFilter("name", "=", (Object)paramKey);
        DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"gai_n2a_param_config", (String)"name,value,value_tag", (QFilter[])new QFilter[]{qFilter});
        if (config != null) {
            String value = config.getString("value");
            String valueTag = config.getString("value_tag");
            return StringUtils.isNotEmpty((String)valueTag) ? valueTag : value;
        }
        return "";
    }
}

