/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.action;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.aimp.cmapp.sdk.cui.CUIFactory;
import kd.aimp.cmapp.sdk.cui.base.convert.CUIConvert;
import kd.aimp.cmapp.sdk.cui.base.dto.BaseDTO;
import kd.aimp.cmapp.sdk.cui.base.dto.BaseVO;
import kd.aimp.cmapp.sdk.cui.base.enums.CUIEnum;
import kd.aimp.cmapp.sdk.cui.think.dto.ThinkDTO;
import kd.aimp.cmapp.sdk.cui.think.handler.ThinkCUIHandler;
import kd.aimp.cmapp.sdk.cui.think.vo.ThinkVO;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CosmicCUIAction
implements IGPTAction {
    private static final Log log = LogFactory.getLog(CosmicCUIAction.class);

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        String cardData;
        log.info("CosmicCUIAction-invokeAction-key:{},map:{}", (Object)s, (Object)JSONObject.toJSONString(map));
        HashMap<String, String> result = new HashMap<String, String>();
        String cuiType = map.get("cuiType");
        String data = map.get("data");
        if (StringUtils.isEmpty((String)cuiType) || StringUtils.isEmpty((String)data)) {
            log.error("CosmicCUIAction-invokeAction-error,cuiType or data is null,map:{}", (Object)JSONObject.toJSONString(map));
            return result;
        }
        CUIEnum cuiEnum = CUIEnum.valueOf(cuiType);
        if (cuiEnum == CUIEnum.ThinkCARD) {
            ThinkDTO thinkDTO = (ThinkDTO)JSONObject.parseObject((String)data, ThinkDTO.class);
            ThinkCUIHandler handler = new ThinkCUIHandler();
            ThinkVO vo = handler.buildCard(thinkDTO);
            cardData = CUIConvert.convertToThinkCUIJson(vo);
        } else {
            Object dto;
            String cuiClassType = map.get("cuiClassType");
            try {
                dto = JSONObject.parseObject((String)data, Class.forName(cuiClassType));
            }
            catch (ClassNotFoundException e) {
                log.error("CosmicCUIAction-invokeAction-error", (Throwable)e);
                return result;
            }
            BaseVO baseVO = CUIFactory.getService(cuiEnum.getCode()).buildCard((BaseDTO)dto);
            cardData = CUIConvert.convertToCUIJson(cuiEnum, baseVO);
        }
        result.put("cardData", cardData);
        log.info("CosmicCUIAction-invokeAction-result:{}", (Object)s, (Object)JSONObject.toJSONString(result));
        return result;
    }
}

