/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.action;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.aimp.cmapp.sdk.chart.handler.CosmicChartHandler;
import kd.aimp.cmapp.sdk.chart.handler.CosmicChartHandlerFactory;
import kd.aimp.cmapp.sdk.dto.CmappMsg;
import kd.aimp.cmapp.sdk.dto.chart.in.BaseData;
import kd.aimp.cmapp.sdk.dto.chart.in.CompareData;
import kd.aimp.cmapp.sdk.dto.chart.in.CosmicUlData;
import kd.aimp.cmapp.sdk.dto.chart.in.RankData;
import kd.aimp.cmapp.sdk.dto.chart.in.SingleData;
import kd.aimp.cmapp.sdk.dto.chart.in.TableData;
import kd.aimp.cmapp.sdk.enums.ChartType;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CosmicChartAction
implements IGPTAction {
    private static final Log log = LogFactory.getLog(CosmicChartAction.class);

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        log.info("CosmicChartAction-invokeAction-key:{},map:{}", (Object)s, (Object)JSONObject.toJSONString(map));
        String type = map.get("chartType");
        CosmicChartHandler<BaseData> handler = CosmicChartHandlerFactory.getHandler(type);
        if (null == handler) {
            log.error("CosmicChartAction-invokeAction-error,no handler,type:{}", (Object)type);
            return null;
        }
        String data = map.get("chartData");
        if (StringUtils.isEmpty((String)data)) {
            log.error("CosmicChartAction-invokeAction-error,no data,type:{}", (Object)data);
            return null;
        }
        BaseData baseData = CosmicChartAction.toBaseData(type, data);
        baseData.setUrl(Optional.ofNullable(map.get("chartUrl")).filter(StringUtils::isNotEmpty).orElseGet(baseData::getUrl));
        String chartStr = handler.buildChart(baseData);
        log.info("CosmicChartAction-invokeAction-result:{}", (Object)chartStr);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("chart", chartStr);
        result.put("CMAPP_MSG", JSONObject.toJSONString((Object)new CmappMsg("metricResult", chartStr)));
        return result;
    }

    private static BaseData toBaseData(String type, String data) {
        BaseData bd;
        switch (ChartType.valueOf(type)) {
            case single: {
                bd = (BaseData)JSONObject.parseObject((String)data, SingleData.class);
                break;
            }
            case compare: {
                bd = (BaseData)JSONObject.parseObject((String)data, CompareData.class);
                break;
            }
            case rank: {
                bd = (BaseData)JSONObject.parseObject((String)data, RankData.class);
                break;
            }
            case select: {
                bd = (BaseData)JSONObject.parseObject((String)data, CosmicUlData.class);
                break;
            }
            default: {
                bd = (BaseData)JSONObject.parseObject((String)data, TableData.class);
            }
        }
        return bd;
    }
}

