/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class CosmicDataConvertAction
implements IGPTAction {
    private static final Log logger = LogFactory.getLog(CosmicDataConvertAction.class);
    private static final int INIT_CAP = 16;

    private static String query(String key) {
        QFilter qFilter = new QFilter("name", "=", (Object)key);
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"gai_n2a_param_config", (String)"name,value,value_tag", (QFilter[])new QFilter[]{qFilter});
        if (configs.length > 0) {
            String value = configs[0].getString("value");
            String valueTag = configs[0].getString("value_tag");
            return StringUtils.isNotEmpty((String)valueTag) ? valueTag : value;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String panelProcessTemplate(String textStr, List<Map<String, Object>> modelValues) {
        HashMap maps = new HashMap(16);
        for (Map<String, Object> map : modelValues) {
            map.forEach((key, value) -> maps.put(key, value));
        }
        try {
            Configuration configuration = CosmicDataConvertAction.configuration();
            String templateName = "paneltemplate";
            String templateValue = "[<#list data as item>{\"title\":\"${item.title}\",\"value\":\"${item.value}\",\"numberFormat\":\"${item.numberFormat}\",<#if item.sub??&&item.sub?size gt 0>\"sub\":[<#list item.sub as subItem>{\"title\":\"${subItem.title}\",\"value\":\"${subItem.value}\"}<#if subItem_has_next>,</#if></#list>]<#else>\"sub\":[]</#if>}<#if item_has_next>,</#if></#list>]";
            Template template = new Template(templateName, templateValue, configuration);
            HashMap rootModel = new HashMap(16);
            ArrayList data = new ArrayList(16);
            JSONObject jsonObject = JSONObject.parseObject((String)textStr, (Feature[])new Feature[]{Feature.OrderedField});
            JSONArray dataArray = jsonObject.getJSONArray("data");
            for (int i = 0; i < dataArray.size(); ++i) {
                JSONObject itemObj = dataArray.getJSONObject(i);
                JSONObject mainObject = itemObj.getJSONObject("main");
                JSONObject subObject = itemObj.getJSONObject("sub");
                String mainKey = (String)mainObject.keySet().iterator().next();
                String subKey = null;
                if (subObject.keySet().size() > 0) {
                    subKey = (String)subObject.keySet().iterator().next();
                }
                HashMap<String, Object> item = new HashMap<String, Object>(16);
                item.put("title", mainObject.get((Object)mainKey));
                if (String.valueOf(mainObject.get((Object)mainKey)).endsWith("\u7387")) {
                    item.put("numberFormat", "{0}0.0%");
                } else {
                    item.put("numberFormat", "");
                }
                item.put("value", maps.get(mainKey));
                if (subKey != null) {
                    ArrayList sub = new ArrayList(16);
                    HashMap<String, Object> subItem = new HashMap<String, Object>(16);
                    subItem.put("title", subObject.get((Object)subKey));
                    subItem.put("value", maps.get(subKey));
                    sub.add(subItem);
                    item.put("sub", sub);
                }
                data.add(item);
            }
            rootModel.put("data", data);
            logger.info("data{}:", (Object)((Object)rootModel).toString());
            try (StringWriter out = new StringWriter();){
                template.process(rootModel, (Writer)out);
                String string = out.toString();
                return string;
            }
        }
        catch (Exception e) {
            logger.error("Exception:{}", (Object)e.getMessage());
            return null;
        }
    }

    private static Configuration configuration() {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_31);
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        configuration.setTemplateLoader((TemplateLoader)templateLoader);
        configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        configuration.setDefaultEncoding("UTF-8");
        return configuration;
    }

    private static Map<String, String> queryFieldDesc(Set<String> keys) {
        JSONObject textJo = new JSONObject();
        for (String key : keys) {
            String businessStr = CosmicDataConvertAction.query(key);
            textJo.put(key, JSONArray.parse((String)businessStr));
        }
        String text = textJo.toJSONString();
        Map resultMap = (Map)JSON.parseObject((String)text, (TypeReference)new TypeReference<Map<String, List<Map<String, Object>>>>(){}, (Feature[])new Feature[0]);
        HashMap<String, String> maps = new HashMap<String, String>(16);
        for (Map.Entry entry : resultMap.entrySet()) {
            for (Map subscrib : (List)entry.getValue()) {
                String name = String.valueOf(subscrib.get("name"));
                String desc = String.valueOf(subscrib.get("desc"));
                name = (String)entry.getKey() + "." + name;
                String type = String.valueOf(subscrib.get("type"));
                Boolean numberic = false;
                if (type.equalsIgnoreCase("DECIMAL")) {
                    numberic = true;
                }
                maps.put(name, desc + ":" + numberic);
            }
        }
        return maps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String tableProcessTemplate(String templateValue, Set<String> keys, String title, String tableType, List<Map<String, Object>> modelValues, String order, String total) throws IOException {
        String fName;
        if (title == null) {
            title = "";
        }
        Map<String, String> maps = CosmicDataConvertAction.queryFieldDesc(keys);
        HashMap<String, Object> dataModel = new HashMap<String, Object>(16);
        dataModel.put("title", title);
        dataModel.put("numberFormat", "{0}#,##0\u5343");
        if (tableType.equalsIgnoreCase("rank")) {
            if (order == null || order.length() == 0) {
                order = "asc";
            }
            if (total == null || total.length() == 0) {
                total = "10";
            }
            dataModel.put("order", order);
            dataModel.put("total", total);
        }
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>(16);
        ArrayList fieldValues = new ArrayList(16);
        int i = 0;
        for (Map<String, Object> model : modelValues) {
            ArrayList<Object> item = new ArrayList<Object>(16);
            for (Map.Entry<String, Object> entry : model.entrySet()) {
                item.add(entry.getValue());
                if (i != 0) continue;
                String name = maps.get(entry.getKey());
                String[] fieldNames = name.split(":");
                fields.add(CosmicDataConvertAction.createFieldMap(entry.getKey(), fieldNames[0], Boolean.parseBoolean(fieldNames[1])));
            }
            ++i;
            fieldValues.add(item);
        }
        if (tableType.equalsIgnoreCase("rank") && (fName = String.valueOf(((Map)fields.get(0)).get("fieldName"))).endsWith("\u7387")) {
            dataModel.put("numberFormat", "{0}0.0%");
        }
        dataModel.put("fields", fields);
        dataModel.put("fieldValues", fieldValues);
        Configuration configuration = CosmicDataConvertAction.configuration();
        Template template = new Template("table", templateValue, configuration);
        Map root = Collections.singletonMap("data", dataModel);
        try (StringWriter out = new StringWriter();){
            template.process(root, (Writer)out);
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("Exception {}", (Object)e.getMessage());
            return null;
        }
    }

    private static Map<String, Object> createFieldMap(String field, String fieldName, boolean numerical) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
        fieldMap.put("field", field);
        fieldMap.put("fieldName", fieldName);
        fieldMap.put("numerical", numerical);
        return fieldMap;
    }

    private static String single(Set<String> keys, String title, String tableType, List<Map<String, Object>> modelValues) {
        Map<String, Object> value = modelValues.get(0);
        JSONObject data = new JSONObject();
        data.put("title", (Object)title);
        data.put("metricName", (Object)"null");
        data.put("metricValue", (Object)"0");
        data.put("numberFormat", (Object)"");
        Map<String, String> maps = CosmicDataConvertAction.queryFieldDesc(keys);
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            String name;
            if (entry.getValue() instanceof String || (name = maps.get(entry.getKey())) == null) continue;
            String[] fieldNames = name.split(":");
            data.put("metricName", (Object)fieldNames[0]);
            String val = String.valueOf(entry.getValue());
            if (name.endsWith("\u7387")) {
                val = String.format("%s%s", new BigDecimal(val).multiply(BigDecimal.valueOf(100L)), "%");
            } else {
                data.put("numberFormat", (Object)"{0}#,##0\u5343");
            }
            data.put("metricValue", (Object)val);
        }
        return JSONObject.toJSONString((Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String textBoardProcessTemplate(String text, String title, Map<String, Object> modelValues) {
        StringWriter writer = null;
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)text, (Feature[])new Feature[]{Feature.OrderedField});
            Configuration configuration = CosmicDataConvertAction.configuration();
            String templateName = "textBoardTemplate";
            String templateValue = "{\"title\":\"${title}\",\"mobile\":\"${(mobile!'')}\",\"content\":\"${content}\",\"info\":\"${(info!'')}\",\"sub\":<#if sub??>[<#list sub as item>{\"title\":\"${item.title}\",\"content\":\"${item.content}\"}<#if item_has_next>,</#if></#list>]<#else>[]</#if>}";
            Template template = new Template(templateName, templateValue, configuration);
            HashMap<String, Object> rootModel = new HashMap<String, Object>(16);
            rootModel.put("title", modelValues.get(jsonObject.getString("title")));
            rootModel.put("mobile", "");
            rootModel.put("info", "");
            String content = jsonObject.getString("content");
            String[] contents = content.split(",");
            ArrayList<String> list = new ArrayList<String>(16);
            for (String con : contents) {
                if (modelValues.get(con) == null || String.valueOf(modelValues.get(con)).length() <= 0) continue;
                list.add(String.valueOf(modelValues.get(con)));
            }
            String target = list.stream().collect(Collectors.joining("\u00b7"));
            rootModel.put("content", target);
            JSONArray sub = jsonObject.getJSONArray("sub");
            HashMap<String, String> maps = new HashMap<String, String>(16);
            for (int i = 0; i < sub.size(); ++i) {
                for (String subKey : sub.getJSONObject(i).keySet()) {
                    if (sub.getJSONObject(i).getString(subKey) == null || sub.getJSONObject(i).getString(subKey).length() <= 0 || modelValues.get(subKey) == null || String.valueOf(modelValues.get(subKey)).length() <= 0) continue;
                    maps.put("title", sub.getJSONObject(i).getString(subKey));
                    maps.put("content", String.valueOf(modelValues.get(subKey)));
                }
            }
            if (maps.size() > 0) {
                List subList = Collections.singletonList(maps);
                rootModel.put("sub", subList);
            }
            writer = new StringWriter();
            template.process(rootModel, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("Exception {}", (Object)e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error("writer close failed");
                }
            }
        }
        return null;
    }

    public static String renderTemplate(String text, Map<String, Object> modelValues) {
        System.out.println("text:" + text + "modelValues:" + modelValues.toString());
        String template = "{\n  \"title\": \"{{title}}\",\n  \"mobile\": \"{{mobile}}\",\n  \"content\": \"{{content}}\",\n  \"info\": \"{{info}}\",\n  \"sub\": [\n    {{#sub}}\n    {\n      \"title\": \"{{title}}\",\n      \"content\": \"{{content}}\"\n    }\n    {{/sub}}\n  ]\n}";
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)new StringReader("template"), "tejm");
        try {
            JSONObject jsonObject = JSON.parseObject((String)text, (Feature[])new Feature[]{Feature.OrderedField});
            HashMap<String, Object> rootModel = new HashMap<String, Object>(16);
            rootModel.put("title", modelValues.get(jsonObject.getString("title")));
            rootModel.put("mobile", "");
            rootModel.put("info", "");
            String content = jsonObject.getString("content");
            String[] contents = content.split(",");
            ArrayList<String> list = new ArrayList<String>(16);
            for (String con : contents) {
                if (modelValues.get(con) == null || String.valueOf(modelValues.get(con)).length() <= 0) continue;
                list.add(String.valueOf(modelValues.get(con)));
            }
            String target = list.stream().collect(Collectors.joining("\u00b7"));
            rootModel.put("content", target);
            JSONArray sub = jsonObject.getJSONArray("sub");
            ArrayList subList = new ArrayList();
            for (int i = 0; i < sub.size(); ++i) {
                JSONObject subObj = sub.getJSONObject(i);
                HashMap<String, String> subMap = new HashMap<String, String>();
                for (String key : subObj.keySet()) {
                    String subKeyVal = subObj.getString(key);
                    if (subKeyVal == null || subKeyVal.length() <= 0 || modelValues.get(key) == null || String.valueOf(modelValues.get(key)).length() <= 0) continue;
                    subMap.put("title", subKeyVal);
                    subMap.put("content", String.valueOf(modelValues.get(key)));
                }
                if (subMap.isEmpty()) continue;
                subList.add(subMap);
            }
            rootModel.put("sub", subList);
            StringWriter writer = new StringWriter();
            mustache.execute((Writer)writer, rootModel).flush();
            return writer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String listBoardProcessTemplate(List<Map<String, Object>> modelValues) {
        StringWriter writer = null;
        try {
            String templateName = "listBoardTemplate";
            String templateValue = "{\"data\":{\"info\":\"${data.info}\",\"url\":\"${data.url}\",\"title\":\"${data.title}\",\"content\":\"${data.content}\",\"list\":[<#list data.list as item>{\"title\":\"${item.title}\",\"sub\":[<#list item.sub as subItem>{\"title\":\"${subItem.title}\",\"content\":\"${subItem.content}\"}<#if subItem_has_next>,</#if></#list>]}<#if item_has_next>,</#if></#list>],\"sub\":[<#list data.sub as sub>{\"title\":\"${sub.title}\",\"content\":\"${sub.content}\"}<#if sub_has_next>,</#if></#list>]}}";
            Configuration configuration = CosmicDataConvertAction.configuration();
            Template template = new Template(templateName, templateValue, configuration);
            HashMap rootModel = new HashMap(16);
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("title", "\u5408\u540c\u6570");
            dataMap.put("content", "10");
            ArrayList<Map<String, String>> subData = new ArrayList<Map<String, String>>(16);
            subData.add(CosmicDataConvertAction.createItem("\u91d1\u8776\u4e91\u661f\u701a", "1"));
            subData.add(CosmicDataConvertAction.createItem("\u91d1\u8776\u4e91\u82cd\u7a79", "1"));
            subData.add(CosmicDataConvertAction.createItem("EAS Cloud", "1"));
            dataMap.put("sub", subData);
            rootModel.put("data", dataMap);
            writer = new StringWriter();
            template.process(rootModel, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (Exception templateName) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error("Exception:{}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String indicatorProcessTemplate(String text, List<Map<String, Object>> modelValues) {
        JSONObject jsonObject = JSONObject.parseObject((String)text, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject main = jsonObject.getJSONObject("main");
        JSONObject sub = jsonObject.getJSONObject("sub");
        JSONObject rateJson = jsonObject.getJSONObject("rate");
        String mainKey = (String)main.keySet().iterator().next();
        String subKey = (String)sub.keySet().iterator().next();
        String rateKey = (String)rateJson.keySet().iterator().next();
        StringWriter writer = null;
        try {
            Configuration configuration = CosmicDataConvertAction.configuration();
            String templateName = "indicatortemplate";
            String templateValue = "{\"title\":\"${title}\",\"value\":\"${value}\",\"rate\":{\"value\":\"${rate.value}\",\"baseValue\":\"${rate.baseValue}\"},\"sub\":[<#list sub as item>{\"title\":\"${item.title}\",\"value\":\"${item.value}\"}</#list>]}";
            HashMap<String, Object> dataModel = new HashMap<String, Object>(16);
            dataModel.put("title", main.get((Object)mainKey));
            for (Map<String, Object> model : modelValues) {
                if (model.get(mainKey) == null) continue;
                dataModel.put("value", model.get(mainKey));
                HashMap<String, String> rate = new HashMap<String, String>(16);
                String value = String.valueOf(model.get(rateKey));
                if (!value.contains("%")) {
                    value = String.format("%s%s", new BigDecimal(value).multiply(BigDecimal.valueOf(100L)), "%");
                }
                rate.put("value", value);
                rate.put("baseValue", "100%");
                dataModel.put("rate", rate);
                HashMap<String, String> maps = new HashMap<String, String>(16);
                maps.put("title", sub.getString(subKey));
                maps.put("value", String.valueOf(model.get(subKey)));
                List subList = Collections.singletonList(maps);
                dataModel.put("sub", subList);
            }
            writer = new StringWriter();
            Template temp = new Template(templateName, "{\"title\":\"${title}\",\"value\":\"${value}\",\"rate\":{\"value\":\"${rate.value}\",\"baseValue\":\"${rate.baseValue}\"},\"sub\":[<#list sub as item>{\"title\":\"${item.title}\",\"value\":\"${item.value}\"}</#list>]}", configuration);
            temp.process(dataModel, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("Exception:{}", (Object)e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error("close writer failed");
                }
            }
        }
        return "";
    }

    private static Map<String, String> createTagItem(String name) {
        HashMap<String, String> tagItem = new HashMap<String, String>(16);
        tagItem.put("name", name);
        return tagItem;
    }

    private static Map<String, String> createItem(String title, String content) {
        HashMap<String, String> item = new HashMap<String, String>(16);
        item.put("title", title);
        item.put("content", content);
        return item;
    }

    public Map<String, String> invokeAction(String action, Map<String, String> map) {
        logger.info("\u4ece\u4e0a\u6e38\u63a5\u6536\u5230\u7684\u53c2\u6570\u4e3a:{}", (Object)map.toString());
        try {
            String table;
            String templateValue;
            HashMap<String, String> rtn = new HashMap<String, String>(16);
            String businessStr = CosmicDataConvertAction.query("businessType");
            Map businessType = (Map)JSONObject.parseObject((String)businessStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            String filedData = map.get("fieldData");
            String type = map.get("type");
            String title = map.get("title");
            String total = map.get("total");
            String order = map.get("order");
            JSONObject dataObj = JSONObject.parseObject((String)filedData);
            Set keys = dataObj.keySet();
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>(16);
            for (String key : keys) {
                JSONObject keyJo = dataObj.getJSONObject(key);
                List fieldNames = keyJo.getJSONArray("fieldNames").toJavaList(String.class);
                JSONArray valuesArray = keyJo.getJSONArray("values");
                for (int i = 0; i < valuesArray.size(); ++i) {
                    JSONArray rowArray = valuesArray.getJSONArray(i);
                    LinkedHashMap<Object, Object> rowMap = new LinkedHashMap<Object, Object>(16);
                    for (int j = 0; j < rowArray.size(); ++j) {
                        if (type.equalsIgnoreCase("textboard")) {
                            rowMap.put(fieldNames.get(j), rowArray.get(j));
                            continue;
                        }
                        rowMap.put(key + "." + (String)fieldNames.get(j), rowArray.get(j));
                    }
                    values.add(rowMap);
                }
            }
            String text = "";
            String[] types = null;
            if (type.equalsIgnoreCase("single")) {
                String single = CosmicDataConvertAction.single(keys, title, type, values);
                rtn.put("data", single);
            } else if (type.equalsIgnoreCase("bar") || type.equalsIgnoreCase("table") || type.equalsIgnoreCase("pie") || type.equalsIgnoreCase("line")) {
                templateValue = "{\"title\":\"${data.title}\",\"numberFormat\":\"${data.numberFormat}\",\"fields\":[<#list data.fields as field>{\"field\":\"${field.field}\",\"fieldName\":\"${field.fieldName}\",\"numerical\":${field.numerical?c}}<#if field_has_next>,</#if></#list>],\"fieldValues\":[<#list data.fieldValues as fieldValue>[<#list fieldValue as value><#if value?is_number>${value}<#else>\"${value}\"</#if><#if value_has_next>,</#if></#list>]<#if fieldValue_has_next>,</#if></#list>]}";
                table = CosmicDataConvertAction.tableProcessTemplate(templateValue, keys, title, type, values, "", "");
                rtn.put("data", table);
            } else if (type.equalsIgnoreCase("rank")) {
                templateValue = "{\"title\":\"${data.title}\",\"numberFormat\":\"${data.numberFormat}\",\"order\":\"${(data.order!'')}\",\"total\":\"${(data.total!'')}\",\"fields\":[<#list data.fields as field>{\"field\":\"${field.field}\",\"fieldName\":\"${field.fieldName}\",\"numerical\":${field.numerical?c}}<#if field_has_next>,</#if></#list>],\"fieldValues\":[<#list data.fieldValues as fieldValue>[<#list fieldValue as value><#if value?is_number>${value}<#else>\"${value}\"</#if><#if value_has_next>,</#if></#list>]<#if fieldValue_has_next>,</#if></#list>]}";
                table = CosmicDataConvertAction.tableProcessTemplate(templateValue, keys, title, type, values, order, total);
                rtn.put("data", table);
            } else {
                String mode = (String)businessType.get(type);
                types = mode.split(",").length == 1 ? new String[]{type} : mode.split(",");
                JSONObject root = new JSONObject();
                JSONArray data = new JSONArray();
                for (String ty : types) {
                    text = CosmicDataConvertAction.query(ty);
                    String mod = (String)businessType.get(ty);
                    if (mod.equals("indiboard")) {
                        String indicator = CosmicDataConvertAction.indicatorProcessTemplate(text, values);
                        JSONObject indiboard = new JSONObject();
                        indiboard.put("type", (Object)"indiboard");
                        indiboard.put("numberFormat", (Object)"{0}#,##0\u5343");
                        indiboard.put("data", (Object)indicator);
                        data.add((Object)indiboard);
                    } else if (mod.equals("panel")) {
                        String textPanel = CosmicDataConvertAction.panelProcessTemplate(text, values);
                        JSONObject panel = new JSONObject();
                        panel.put("type", (Object)"panel");
                        panel.put("numberFormat", (Object)"{0}#,##0\u5343");
                        panel.put("data", (Object)textPanel);
                        data.add((Object)panel);
                    } else if (mod.equalsIgnoreCase("textboard")) {
                        String textboard = CosmicDataConvertAction.textBoardProcessTemplate(text, title, (Map)values.get(0));
                        JSONObject textJson = new JSONObject();
                        textJson.put("type", (Object)"textboard");
                        textJson.put("data", (Object)textboard);
                        data.add((Object)textJson);
                    }
                    root.put("data", (Object)data);
                }
                rtn.put("data", root.toJSONString());
            }
            return rtn;
        }
        catch (Exception e) {
            logger.error("Exception:{}", (Object)e.getMessage());
            return new HashMap<String, String>(16);
        }
    }
}

