/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import kd.aimp.cmapp.sdk.constants.CmappConstant;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CosmicJsonExtractAction
implements IGPTAction {
    private static final Log log = LogFactory.getLog(CosmicJsonExtractAction.class);

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        Object jsonObj;
        log.info("CosmicJsonAnalysisAction-invokeAction-key:{},map:{}", (Object)s, (Object)JSONObject.toJSONString(map));
        String jsonData = map.get("jsonData");
        String kdJel = map.get("KD_JEL");
        if (StringUtils.isEmpty((String)kdJel)) {
            log.error("CosmicJsonAnalysisAction-invokeAction-error,no KD_JEL");
            return null;
        }
        if (StringUtils.isEmpty((String)jsonData)) {
            log.error("CosmicJsonAnalysisAction-invokeAction-error,no jsonData");
            return null;
        }
        try {
            jsonObj = JSONObject.parse((String)jsonData);
        }
        catch (Exception e) {
            log.error("CosmicJsonAnalysisAction-invokeAction-error,not json,data:{}", (Object)jsonData);
            return null;
        }
        Object matchObj = this.matchAndGet(map, jsonObj, this.toJelList(kdJel));
        if (null == matchObj) {
            log.error("CosmicJsonAnalysisAction-invokeAction-error,not match");
        }
        String resultData = Optional.ofNullable(matchObj).map(o -> {
            if (o instanceof JSONObject || o instanceof JSONArray) {
                return JSONObject.toJSONString((Object)o);
            }
            return String.valueOf(o);
        }).orElse(null);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("data", resultData);
        result.put("match", String.valueOf(null != matchObj));
        log.info("CosmicJsonAnalysisAction-invokeAction-result:{}", (Object)JSONObject.toJSONString(result));
        return result;
    }

    private List<String> toJelList(String jelStr) {
        String[] strs = jelStr.split("\\.");
        ArrayList<String> arr = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String s : strs) {
            if (s.contains("{") && !s.contains("}")) {
                sb.append(s);
                sb.append(".");
                continue;
            }
            if (s.contains("}") && !s.contains("{")) {
                sb.append(s);
                arr.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (sb.toString().contains("{")) {
                sb.append(s);
                sb.append(".");
                continue;
            }
            arr.add(s);
        }
        return arr;
    }

    private Object matchAndGet(Map<String, String> map, Object jsonData, List<String> jelArr) {
        Object matchObj = null;
        for (String s : jelArr) {
            String value;
            Matcher elMatcher = CmappConstant.EL_PATTERN.matcher(s);
            Matcher arrayMatcher = CmappConstant.ARRAY_PATTERN.matcher(s);
            if (elMatcher.find()) {
                value = map.get(elMatcher.group(1));
                if (null != matchObj) {
                    JSONObject o = (JSONObject)matchObj;
                    matchObj = o.get((Object)value);
                } else if (jsonData instanceof JSONObject) {
                    JSONObject json = (JSONObject)jsonData;
                    matchObj = json.get((Object)value);
                }
            } else if (arrayMatcher.find()) {
                value = arrayMatcher.group(1);
                int idx = Integer.parseInt(value);
                if (null != matchObj) {
                    JSONArray o = (JSONArray)matchObj;
                    matchObj = idx >= o.size() ? null : o.get(idx);
                } else if (jsonData instanceof JSONArray) {
                    JSONArray json = (JSONArray)jsonData;
                    matchObj = idx >= json.size() ? null : json.get(idx);
                }
            } else if (null != matchObj) {
                JSONObject o = (JSONObject)matchObj;
                matchObj = o.get((Object)s);
            } else if (jsonData instanceof JSONObject) {
                JSONObject json = (JSONObject)jsonData;
                matchObj = json.get((Object)s);
            }
            if (null != matchObj) continue;
            break;
        }
        return matchObj;
    }
}

