/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.aimp.cmapp.sdk.chart.handler.CosmicChartHandler;
import kd.aimp.cmapp.sdk.chart.handler.CosmicChartHandlerFactory;
import kd.aimp.cmapp.sdk.dto.CmappMsg;
import kd.aimp.cmapp.sdk.dto.Knowledge;
import kd.aimp.cmapp.sdk.dto.chart.in.BaseData;
import kd.aimp.cmapp.sdk.dto.chart.in.CosmicUlData;
import kd.aimp.cmapp.sdk.enums.ChartType;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class CosmicKnowConvartAction
implements IGPTAction {
    private static final Log log = LogFactory.getLog(CosmicKnowConvartAction.class);

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        log.info("CosmicKnowConvartAction-invokeAction-key:{},map:{}", (Object)s, (Object)JSONObject.toJSONString(map));
        String know = map.get("knowledge");
        String field = map.get("field");
        String fieldName = map.get("fieldName");
        boolean multi = Boolean.parseBoolean(map.get("multi"));
        if (StringUtils.isEmpty((String)know)) {
            log.error("CosmicKnowConvartAction-invokeAction-error,no knowledge");
            return null;
        }
        List knowledges = JSONArray.parseArray((String)know, Knowledge.class);
        if (CollectionUtils.isEmpty((Collection)knowledges)) {
            log.error("CosmicKnowConvartAction-invokeAction-error,no knowledge,know:{}", (Object)know);
            return null;
        }
        CosmicUlData cosmicUlData = CosmicKnowConvartAction.convert(knowledges, field, fieldName, multi);
        CosmicChartHandler<BaseData> handler = CosmicChartHandlerFactory.getHandler(ChartType.select);
        String chartStr = handler.buildChart(cosmicUlData);
        log.info("CosmicKnowConvartAction-invokeAction-result:{}", (Object)chartStr);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("chart", chartStr);
        result.put("CMAPP_MSG", JSONObject.toJSONString((Object)new CmappMsg("metricResult", chartStr)));
        return result;
    }

    private static CosmicUlData convert(List<Knowledge> knowledges, String field, String fieldName, boolean multi) {
        List<CosmicUlData.SelectValue> selectValues = knowledges.stream().map(know -> {
            CosmicUlData.SelectValue selectValue = new CosmicUlData.SelectValue();
            selectValue.setName(know.getChunk());
            return selectValue;
        }).collect(Collectors.toList());
        CosmicUlData data = new CosmicUlData();
        data.setField(field);
        data.setFieldName(fieldName);
        data.setMulti(multi);
        data.setValues(selectValues);
        return data;
    }
}

